/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public abstract class AbstractPMDRecord {
    public static final int TYPE_ROOT = 8;
    public static final int TYPE_PROJECT = 4;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_MARKER = 16;
    public static final AbstractPMDRecord[] EMPTY_RECORDS = new AbstractPMDRecord[0];

    public abstract String getName();

    public abstract AbstractPMDRecord getParent();

    public abstract AbstractPMDRecord[] getChildren();

    public List<AbstractPMDRecord> getChildrenAsList() {
        return new ArrayList<AbstractPMDRecord>(Arrays.asList(this.getChildren()));
    }

    public abstract IResource getResource();

    public abstract int getResourceType();

    public abstract AbstractPMDRecord addResource(IResource var1);

    public abstract AbstractPMDRecord removeResource(IResource var1);

    public abstract int getNumberOfViolationsToPriority(int var1, boolean var2);

    public abstract int getLOC();

    public abstract int getNumberOfMethods();

    protected abstract AbstractPMDRecord[] createChildren();

    public boolean hasMarkers() {
        AbstractPMDRecord[] children = this.getChildren();
        boolean result = false;
        int i = 0;
        while (i < children.length && !result) {
            if (children[i].hasMarkers()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public IMarker[] findMarkers() {
        AbstractPMDRecord[] children;
        ArrayList<IMarker> markerList = new ArrayList<IMarker>();
        AbstractPMDRecord[] abstractPMDRecordArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker[] childrenMarkers;
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            if (element.hasMarkers() && (childrenMarkers = element.findMarkers()) != null) {
                markerList.addAll(Arrays.asList(childrenMarkers));
            }
            ++n2;
        }
        return markerList.isEmpty() ? null : markerList.toArray(new IMarker[markerList.size()]);
    }

    public IMarker[] findMarkersByAttribute(String attributeName, Object value) {
        AbstractPMDRecord[] children;
        ArrayList<IMarker> markerList = new ArrayList<IMarker>();
        AbstractPMDRecord[] abstractPMDRecordArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            IMarker[] childrenMarkers = element.findMarkersByAttribute(attributeName, value);
            markerList.addAll(Arrays.asList(childrenMarkers));
            ++n2;
        }
        return markerList.toArray(new IMarker[markerList.size()]);
    }

    public AbstractPMDRecord findResource(IResource resource) {
        AbstractPMDRecord record = null;
        List<AbstractPMDRecord> thisChildren = this.getChildrenAsList();
        int l = 0;
        while (l < thisChildren.size() && record == null) {
            AbstractPMDRecord grandChild;
            AbstractPMDRecord thisChild = thisChildren.get(l);
            if (thisChild.getResource().equals((Object)resource)) {
                record = thisChild;
            } else if (thisChild.getResourceType() != resource.getType() && (grandChild = thisChild.findResource(resource)) != null) {
                record = grandChild;
            }
            ++l;
        }
        return record;
    }

    public AbstractPMDRecord findResourceByName(String name, int type) {
        AbstractPMDRecord record = null;
        List<AbstractPMDRecord> thisChildren = this.getChildrenAsList();
        int l = 0;
        while (l < thisChildren.size() && record == null) {
            AbstractPMDRecord thisChild = thisChildren.get(l);
            if (thisChild.getResourceType() == type && thisChild.getName().equalsIgnoreCase(name)) {
                record = thisChild;
            } else {
                AbstractPMDRecord grandChild = thisChild.findResourceByName(name, type);
                if (grandChild != null) {
                    record = grandChild;
                }
            }
            ++l;
        }
        return record;
    }

    public List<AbstractPMDRecord> findResourcesByName(String name, int type) {
        ArrayList<AbstractPMDRecord> records = new ArrayList<AbstractPMDRecord>();
        List<AbstractPMDRecord> thisChildren = this.getChildrenAsList();
        for (AbstractPMDRecord thisChild : thisChildren) {
            if (thisChild.getResourceType() == type && thisChild.getName().equalsIgnoreCase(name)) {
                records.add(thisChild);
                continue;
            }
            List<AbstractPMDRecord> grandChilds = thisChild.findResourcesByName(name, type);
            records.addAll(grandChilds);
        }
        return records;
    }
}

