/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;

public class PMDCheckAction
extends AbstractUIAction {
    private static final Logger log = Logger.getLogger(PMDCheckAction.class);

    public void run(IAction action) {
        log.info((Object)"Check PMD action requested");
        try {
            if (this.isViewPart()) {
                ISelection selection = this.targetSelection();
                if (selection instanceof IStructuredSelection) {
                    this.reviewSelectedResources((IStructuredSelection)selection);
                } else {
                    log.debug((Object)("The selection is not an instance of IStructuredSelection. This is not supported: " + selection.getClass().getName()));
                }
            } else if (this.isEditorPart()) {
                IEditorInput editorInput = ((IEditorPart)this.targetPart()).getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    this.reviewSingleResource((IResource)((IFileEditorInput)editorInput).getFile());
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + editorInput.getClass().getName()));
                }
            } else {
                log.debug((Object)("Running PMD from this kind of part is not supported. Part is of type " + this.targetPartClassName()));
            }
        }
        catch (CommandException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void reviewSingleResource(IResource resource) throws CommandException {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.addResource(resource);
        this.setupAndExecute(cmd, 1);
    }

    private void setupAndExecute(ReviewCodeCmd cmd, int count) throws CommandException {
        cmd.setStepCount(count);
        cmd.setTaskMarker(true);
        cmd.setOpenPmdPerspective(PMDPlugin.getDefault().loadPreferences().isPmdPerspectiveEnabled());
        cmd.setUserInitiated(true);
        cmd.setRunAlways(true);
        cmd.performExecute();
    }

    private void reviewSelectedResources(IStructuredSelection selection) throws CommandException {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        for (Object element : selection) {
            if (element instanceof AbstractPMDRecord) {
                IResource resource = ((AbstractPMDRecord)element).getResource();
                if (resource != null) {
                    cmd.addResource(resource);
                    continue;
                }
                log.warn((Object)"The selected object has no resource");
                log.debug((Object)("  -> selected object : " + element));
                continue;
            }
            if (element instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)element;
                IAdaptable[] iAdaptableArray = set.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    this.addAdaptable(cmd, adaptable);
                    ++n2;
                }
                continue;
            }
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                this.addAdaptable(cmd, adaptable);
                continue;
            }
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + element));
        }
        this.setupAndExecute(cmd, this.countElements(selection));
    }

    private void addAdaptable(ReviewCodeCmd cmd, IAdaptable adaptable) {
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource != null) {
            cmd.addResource(resource);
        } else {
            log.warn((Object)"The selected object cannot adapt to a resource");
            log.debug((Object)("   -> selected object : " + adaptable));
        }
    }

    private int countElements(IStructuredSelection selection) {
        CountVisitor visitor = new CountVisitor();
        for (Object element : selection) {
            try {
                if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                    if (resource != null) {
                        resource.accept((IResourceVisitor)visitor);
                        continue;
                    }
                    log.warn((Object)"The selected object cannot adapt to a resource");
                    log.debug((Object)("   -> selected object : " + element));
                    continue;
                }
                log.warn((Object)"The selected object is not adaptable");
                log.debug((Object)("   -> selected object : " + element));
            }
            catch (CoreException e) {
                this.logError("Exception when counting the number of impacted elements when running PMD from menu", e);
            }
        }
        return visitor.count;
    }

    private class CountVisitor
    implements IResourceVisitor {
        public int count = 0;

        private CountVisitor() {
        }

        public boolean visit(IResource resource) {
            boolean fVisitChildren = true;
            ++this.count;
            if (resource instanceof IFile && AbstractDefaultCommand.isJavaFile((IFile)resource)) {
                fVisitChildren = false;
            }
            return fVisitChildren;
        }
    }
}

