/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import net.sourceforge.pmd.eclipse.ui.AbstractColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SortListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueFormatter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ItemColumnDescriptor<T, V>
extends AbstractColumnDescriptor {
    private final ItemFieldAccessor<T, V> accessor;
    private final ValueFormatter[] formatters;

    public ItemColumnDescriptor(String theId, String labelKey, int theAlignment, int theWidth, boolean resizableFlag, ItemFieldAccessor<T, V> theAccessor) {
        this(theId, labelKey, theAlignment, theWidth, resizableFlag, theAccessor, null);
    }

    public ItemColumnDescriptor(String theId, String labelKey, int theAlignment, int theWidth, boolean resizableFlag, ItemFieldAccessor<T, V> theAccessor, ValueFormatter[] theFormatters) {
        super(theId, labelKey, theAlignment, theWidth, resizableFlag, null);
        this.accessor = theAccessor;
        this.formatters = theFormatters;
    }

    public T valueFor(V item) {
        return this.accessor.valueFor(item);
    }

    private int preferredFormatter() {
        return this.formatters != null && this.formatters.length == 1 ? 0 : -1;
    }

    public String textFor(V item) {
        return this.textFor(item, this.preferredFormatter());
    }

    public String textFor(V item, int formatterIndex) {
        T value = this.valueFor(item);
        return formatterIndex < 0 ? (value == null ? "" : String.valueOf(value)) : this.formatters[formatterIndex].format(value);
    }

    public Image imageFor(V item) {
        return this.accessor.imageFor(item);
    }

    public TableColumn buildTableColumn(Table parent, final SortListener sortListener) {
        TableColumn tc = super.buildTableColumn(parent);
        tc.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                sortListener.sortBy(ItemColumnDescriptor.this.accessor, e.widget);
            }
        });
        return tc;
    }

    public ValueFormatter[] formatters() {
        return this.formatters;
    }

    public ItemFieldAccessor<T, V> getAccessor() {
        return this.accessor;
    }
}

