/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictResolution;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class ConflictHandlingWizardPage
extends WizardPage {
    private SVNConflictDescriptor conflictDescriptor;
    private IResource resource;
    private Button markConflictedButton;
    private Button chooseUserVersionButton;
    private Button chooseUserVersionForConflictsButton;
    private Button chooseIncomingVersionButton;
    private Button chooseIncomingVersionForConflictsButton;
    private Button chooseBaseVersionButton;
    private Button fileEditorButton;
    private Button conflictEditorButton;
    private Button applyToAllButton;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private static final String LAST_TEXT_CHOICE = "ConflictHandlingDialog.lastTextChoice";
    private static final String LAST_BINARY_CHOICE = "ConflictHandlingDialog.lastBinaryChoice";

    public ConflictHandlingWizardPage(String pageName) {
        super(pageName, Messages.ConflictHandlingWizardPage_0, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"));
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        IResource conflictResource = SVNWorkspaceRoot.getResourceFor((IResource)this.resource, (IPath)new Path(this.conflictDescriptor.getPath()));
        Label label = new Label(composite, 64);
        if (conflictResource == null) {
            String workspaceLocation = this.resource.getWorkspace().getRoot().getLocation().toString();
            String relativePath = this.conflictDescriptor.getPath().startsWith(workspaceLocation) ? this.conflictDescriptor.getPath().substring(workspaceLocation.length() + 1) : this.conflictDescriptor.getPath();
            label.setText(String.valueOf(Messages.ConflictHandlingWizardPage_1) + this.convertTempFileName(relativePath));
        } else {
            label.setText(String.valueOf(Messages.ConflictHandlingWizardPage_2) + conflictResource.getFullPath().makeRelative().toOSString());
        }
        data = new GridData();
        data.widthHint = 500;
        label.setLayoutData((Object)data);
        new Label(composite, 0);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Messages.ConflictHandlingWizardPage_3);
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        data = new GridData(1808);
        conflictGroup.setLayoutData((Object)data);
        this.markConflictedButton = new Button((Composite)conflictGroup, 16);
        this.markConflictedButton.setText(Messages.ConflictHandlingWizardPage_4);
        if (this.conflictDescriptor.getReason() == 2 || this.conflictDescriptor.getReason() == 7) {
            this.chooseUserVersionButton = new Button((Composite)conflictGroup, 16);
            this.chooseUserVersionButton.setText(Messages.ConflictHandlingWizardPage_18);
            this.chooseIncomingVersionButton = new Button((Composite)conflictGroup, 16);
            this.chooseIncomingVersionButton.setText(Messages.ConflictHandlingWizardPage_19);
        } else {
            if (this.conflictDescriptor.getMyPath() != null) {
                this.chooseUserVersionButton = new Button((Composite)conflictGroup, 16);
                if (this.conflictDescriptor.getConflictKind() == 1) {
                    this.chooseUserVersionButton.setText(Messages.ConflictHandlingWizardPage_5);
                } else {
                    this.chooseUserVersionButton.setText(Messages.ConflictHandlingWizardPage_6);
                    if (!this.conflictDescriptor.isBinary()) {
                        this.chooseUserVersionForConflictsButton = new Button((Composite)conflictGroup, 16);
                        this.chooseUserVersionForConflictsButton.setText(Messages.ConflictHandlingWizardPage_16);
                    }
                }
            }
            if (this.conflictDescriptor.getTheirPath() != null) {
                this.chooseIncomingVersionButton = new Button((Composite)conflictGroup, 16);
                if (this.conflictDescriptor.getConflictKind() == 1) {
                    this.chooseIncomingVersionButton.setText(Messages.ConflictHandlingWizardPage_7);
                } else {
                    this.chooseIncomingVersionButton.setText(Messages.ConflictHandlingWizardPage_8);
                    if (!this.conflictDescriptor.isBinary()) {
                        this.chooseIncomingVersionForConflictsButton = new Button((Composite)conflictGroup, 16);
                        this.chooseIncomingVersionForConflictsButton.setText(Messages.ConflictHandlingWizardPage_17);
                    }
                }
            }
            if (!this.conflictDescriptor.isBinary() && this.conflictDescriptor.getConflictKind() != 1 && this.fileExists(this.conflictDescriptor.getMergedPath())) {
                this.fileEditorButton = new Button((Composite)conflictGroup, 16);
                this.fileEditorButton.setText(Messages.ConflictHandlingWizardPage_9);
            }
            if (this.showConflictEditorOption()) {
                this.conflictEditorButton = new Button((Composite)conflictGroup, 16);
                if (this.conflictDescriptor.getConflictKind() == 1 && this.conflictDescriptor.getMergedPath() == null) {
                    this.conflictEditorButton.setText(Messages.ConflictHandlingWizardPage_10);
                } else {
                    this.conflictEditorButton.setText(Messages.ConflictHandlingWizardPage_11);
                }
            }
        }
        int lastChoice = 0;
        try {
            lastChoice = this.conflictDescriptor.isBinary() ? this.settings.getInt(LAST_BINARY_CHOICE) : this.settings.getInt(LAST_TEXT_CHOICE);
        }
        catch (Exception exception) {}
        if (lastChoice == 0) {
            this.markConflictedButton.setSelection(true);
        } else if (lastChoice == 5 && this.chooseUserVersionForConflictsButton != null) {
            this.chooseUserVersionForConflictsButton.setSelection(true);
        } else if (lastChoice == 3 && this.chooseUserVersionButton != null) {
            this.chooseUserVersionButton.setSelection(true);
        } else if (lastChoice == 4 && this.chooseIncomingVersionForConflictsButton != null) {
            this.chooseIncomingVersionForConflictsButton.setSelection(true);
        } else if (lastChoice == 2 && this.chooseIncomingVersionButton != null) {
            this.chooseIncomingVersionButton.setSelection(true);
        } else if (lastChoice == 1 && this.chooseBaseVersionButton != null) {
            this.chooseBaseVersionButton.setSelection(true);
        }
        if (lastChoice == 21 && this.conflictEditorButton != null) {
            this.conflictEditorButton.setSelection(true);
        }
        if (!this.conflictDescriptor.isBinary() && this.conflictDescriptor.getConflictKind() != 1 && lastChoice == 20) {
            this.fileEditorButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConflictHandlingWizardPage.this.conflictDescriptor.isBinary()) {
                    if (ConflictHandlingWizardPage.this.markConflictedButton.getSelection()) {
                        ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_BINARY_CHOICE, 0);
                    } else if (ConflictHandlingWizardPage.this.chooseUserVersionButton != null && ConflictHandlingWizardPage.this.chooseUserVersionButton.getSelection()) {
                        ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_BINARY_CHOICE, 3);
                    } else if (ConflictHandlingWizardPage.this.chooseIncomingVersionButton != null && ConflictHandlingWizardPage.this.chooseIncomingVersionButton.getSelection()) {
                        ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_BINARY_CHOICE, 2);
                    } else if (ConflictHandlingWizardPage.this.chooseBaseVersionButton != null && ConflictHandlingWizardPage.this.chooseBaseVersionButton.getSelection()) {
                        ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_BINARY_CHOICE, 1);
                    }
                } else if (ConflictHandlingWizardPage.this.markConflictedButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 0);
                } else if (ConflictHandlingWizardPage.this.chooseUserVersionButton != null && ConflictHandlingWizardPage.this.chooseUserVersionButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 3);
                } else if (ConflictHandlingWizardPage.this.chooseUserVersionForConflictsButton != null && ConflictHandlingWizardPage.this.chooseUserVersionForConflictsButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 5);
                } else if (ConflictHandlingWizardPage.this.chooseIncomingVersionButton != null && ConflictHandlingWizardPage.this.chooseIncomingVersionButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 2);
                } else if (ConflictHandlingWizardPage.this.chooseIncomingVersionForConflictsButton != null && ConflictHandlingWizardPage.this.chooseIncomingVersionForConflictsButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 4);
                } else if (ConflictHandlingWizardPage.this.chooseBaseVersionButton != null && ConflictHandlingWizardPage.this.chooseBaseVersionButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 1);
                } else if (ConflictHandlingWizardPage.this.fileEditorButton != null && ConflictHandlingWizardPage.this.fileEditorButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 20);
                }
                if (ConflictHandlingWizardPage.this.conflictEditorButton != null && ConflictHandlingWizardPage.this.conflictEditorButton.getSelection()) {
                    ConflictHandlingWizardPage.this.settings.put(ConflictHandlingWizardPage.LAST_TEXT_CHOICE, 21);
                }
            }
        };
        this.markConflictedButton.addSelectionListener((SelectionListener)selectionListener);
        if (this.chooseIncomingVersionButton != null) {
            this.chooseIncomingVersionButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.chooseIncomingVersionForConflictsButton != null) {
            this.chooseIncomingVersionForConflictsButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.chooseUserVersionButton != null) {
            this.chooseUserVersionButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.chooseUserVersionForConflictsButton != null) {
            this.chooseUserVersionForConflictsButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.chooseBaseVersionButton != null) {
            this.chooseBaseVersionButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (!this.conflictDescriptor.isBinary() && this.fileEditorButton != null) {
            this.fileEditorButton.addSelectionListener((SelectionListener)selectionListener);
        }
        if (this.conflictEditorButton != null) {
            this.conflictEditorButton.addSelectionListener((SelectionListener)selectionListener);
        }
        this.applyToAllButton = new Button(composite, 32);
        if (this.conflictDescriptor.getReason() == 2 || this.conflictDescriptor.getReason() == 7) {
            this.applyToAllButton.setText(Messages.ConflictHandlingWizardPage_20);
        } else if (this.conflictDescriptor.getConflictKind() == 1) {
            this.applyToAllButton.setText(Messages.ConflictHandlingWizardPage_12);
        } else if (this.conflictDescriptor.isBinary()) {
            this.applyToAllButton.setText(Messages.ConflictHandlingWizardPage_13);
        } else {
            this.applyToAllButton.setText(Messages.ConflictHandlingWizardPage_14);
        }
        File file = new File(this.conflictDescriptor.getPath());
        if (this.conflictDescriptor.getReason() == 2 || this.conflictDescriptor.getReason() == 7) {
            this.setMessage("Tree conflict on " + this.convertTempFileName(file.getName()) + ".");
        } else if (this.conflictDescriptor.getConflictKind() == 1) {
            this.setMessage("SVN cannot automatically merge property " + this.conflictDescriptor.getPropertyName() + Messages.ConflictHandlingWizardPage_15 + this.convertTempFileName(file.getName()) + ".");
        } else {
            this.setMessage("SVN cannot automatically merge file " + this.convertTempFileName(file.getName()) + ".");
        }
        this.setControl((Control)outerContainer);
    }

    public void setConflictDescriptor(SVNConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    public ConflictResolution getConflictResolution() {
        int resolution = 0;
        if (this.markConflictedButton.getSelection()) {
            resolution = 0;
        } else if (this.chooseIncomingVersionButton != null && this.chooseIncomingVersionButton.getSelection()) {
            resolution = this.conflictDescriptor.getReason() == 2 || this.conflictDescriptor.getReason() == 7 ? 6 : 2;
        } else if (this.chooseIncomingVersionForConflictsButton != null && this.chooseIncomingVersionForConflictsButton.getSelection()) {
            resolution = 4;
        } else if (this.chooseUserVersionButton != null && this.chooseUserVersionButton.getSelection()) {
            resolution = this.conflictDescriptor.getReason() == 2 || this.conflictDescriptor.getReason() == 7 ? 5 : 3;
        } else if (this.chooseUserVersionForConflictsButton != null && this.chooseUserVersionForConflictsButton.getSelection()) {
            resolution = 5;
        } else if (this.chooseBaseVersionButton != null && this.chooseBaseVersionButton.getSelection()) {
            resolution = 1;
        }
        if (!this.conflictDescriptor.isBinary() && this.fileEditorButton != null && this.fileEditorButton.getSelection()) {
            resolution = 20;
        }
        if (this.conflictEditorButton != null && this.conflictEditorButton.getSelection()) {
            resolution = 21;
        }
        ConflictResolution conflictResolution = new ConflictResolution(this.conflictDescriptor, resolution);
        conflictResolution.setApplyToAll(this.applyToAllButton.getSelection());
        return conflictResolution;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    private String convertTempFileName(String name) {
        String newName;
        int index;
        if (name.endsWith(".tmp") && (index = (newName = name.substring(0, name.length() - 4)).lastIndexOf(".")) != -1 && newName.substring(index).indexOf("/") == -1) {
            newName = newName.substring(0, index);
            return newName;
        }
        return name;
    }

    private boolean fileExists(String path) {
        if (path != null && path.length() > 0) {
            File file = new File(path);
            return file.exists();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean showConflictEditorOption() {
        if (!this.fileExists(this.conflictDescriptor.getBasePath())) {
            return false;
        }
        if (this.conflictDescriptor.getReason() == 2) return false;
        if (this.conflictDescriptor.getReason() == 7) {
            return false;
        }
        if (!this.conflictDescriptor.isBinary()) return true;
        File pathFile = new File(this.conflictDescriptor.getPath());
        try {
            MergeFileAssociation[] mergeFileAssociations = SVNUIPlugin.getPlugin().getMergeFileAssociations();
            if (mergeFileAssociations == null) return false;
            int i = 0;
            while (true) {
                if (i >= mergeFileAssociations.length) {
                    return false;
                }
                if (mergeFileAssociations[i].matches(pathFile.getName())) return true;
                if (mergeFileAssociations[i].getFileType().equals(pathFile.getName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

