/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.AddResourcesCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.RevisionAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceSummaryNode;
import org.tigris.subversion.subclipse.ui.compare.StatusAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SummaryDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SummaryEditionNode;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class SVNLocalCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private Object fRoot;
    private final SVNRevision remoteRevision;
    private ISVNLocalResource resource;
    private ISVNRemoteResource remoteResource;
    private SVNRevision pegRevision;
    private boolean readOnly;
    private File diffFile;
    private ShowDifferencesAsUnifiedDiffOperationWC diffOperation;
    private ISVNLocalResource[] resources;
    private ISVNRemoteFolder[] remoteFolders;
    private List<IResource> unaddedList = new ArrayList<IResource>();
    private List<IResource> unversionedFolders = new ArrayList<IResource>();

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision, boolean readOnly) throws SVNException, SVNClientException {
        super(new CompareConfiguration());
        this.remoteRevision = revision;
        this.readOnly = readOnly;
        this.resource = resource;
        LocalResourceStatus status = resource.getStatus();
        if (status != null && status.isCopied()) {
            ISVNClientAdapter svnClient = null;
            try {
                svnClient = resource.getRepository().getSVNClient();
                ISVNInfo info = svnClient.getInfoFromWorkingCopy(resource.getFile());
                SVNUrl copiedFromUrl = info.getCopyUrl();
                if (copiedFromUrl != null) {
                    GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(resource.getRepository(), copiedFromUrl, SVNRevision.HEAD);
                    getRemoteResourceCommand.run(null);
                    this.remoteResource = getRemoteResourceCommand.getRemoteResource();
                }
            }
            finally {
                resource.getRepository().returnSVNClient(svnClient);
            }
        }
        if (this.remoteResource == null) {
            this.remoteResource = resource.getRemoteResource(revision);
        }
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision) throws SVNException, SVNClientException {
        this(resource, revision, false);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, ISVNRemoteResource remoteResource) throws SVNException {
        this(resource, remoteResource, null);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, ISVNRemoteResource remoteResource, SVNRevision pegRevision) throws SVNException {
        super(new CompareConfiguration());
        this.resource = resource;
        this.remoteResource = remoteResource;
        this.remoteRevision = remoteResource.getRevision();
        this.pegRevision = pegRevision;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        String leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String remoteResourceName = null;
        remoteResourceName = this.remoteResource != null ? this.remoteResource.getName() : resourceName;
        String rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{remoteResourceName});
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InterruptedException {
        this.initLabels();
        if (this.resource instanceof LocalFolder) {
            try {
                DiffNode diffNode;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 30);
                SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
                sub.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 100);
                Object[] result = new Object[1];
                ArrayList<SVNLocalResourceSummaryNode> resourceSummaryNodeList = new ArrayList<SVNLocalResourceSummaryNode>();
                ArrayList<SummaryEditionNode> summaryEditionNodeList = new ArrayList<SummaryEditionNode>();
                ISVNClientAdapter client = null;
                if (this.resources == null) {
                    this.resources = new ISVNLocalResource[]{this.resource};
                }
                if (this.remoteFolders == null) {
                    this.remoteFolders = new ISVNRemoteFolder[]{(ISVNRemoteFolder)this.remoteResource};
                }
                try {
                    int i = 0;
                    while (i < this.resources.length) {
                        ISVNLocalResource resource = this.resources[i];
                        ISVNRemoteFolder remoteFolder = this.remoteFolders[i];
                        SVNDiffSummary[] diffSummary = null;
                        client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                        File file = new File(resource.getResource().getLocation().toString());
                        this.getUnadded(client, resource, file);
                        IResource[] unaddedResources = new IResource[this.unaddedList.size()];
                        this.unaddedList.toArray(unaddedResources);
                        SVNWorkspaceRoot workspaceRoot = new SVNWorkspaceRoot((IContainer)resource.getResource().getProject());
                        AddResourcesCommand command = new AddResourcesCommand(workspaceRoot, unaddedResources, 2);
                        command.run(monitor);
                        diffSummary = client.diffSummarize(file, remoteFolder.getUrl(), remoteFolder.getRevision(), true);
                        IResource[] iResourceArray = unaddedResources;
                        int n = 0;
                        int n2 = iResourceArray.length;
                        while (n < n2) {
                            IResource unaddedResource = iResourceArray[n];
                            try {
                                SVNWorkspaceRoot.getSVNResourceFor((IResource)unaddedResource).revert();
                            }
                            catch (Exception exception) {}
                            ++n;
                        }
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                        client = null;
                        if (diffSummary != null && diffSummary.length > 0) {
                            diffSummary = this.getDiffSummaryWithSubfolders(diffSummary);
                            SVNLocalResourceSummaryNode left = new SVNLocalResourceSummaryNode(resource, diffSummary, resource.getResource().getLocation().toString());
                            SummaryEditionNode right = new SummaryEditionNode((ISVNRemoteResource)remoteFolder);
                            right.setName(resource.getFile().getName());
                            right.setRootFolder((RemoteFolder)remoteFolder);
                            right.setNodeType(1);
                            right.setRoot(true);
                            right.setDiffSummary(diffSummary);
                            String localCharset = Utilities.getCharset(resource.getIResource());
                            try {
                                right.setCharset(localCharset);
                            }
                            catch (CoreException e) {
                                SVNUIPlugin.log(4, e.getMessage(), e);
                            }
                            resourceSummaryNodeList.add(left);
                            summaryEditionNodeList.add(right);
                        }
                        ++i;
                    }
                    if (resourceSummaryNodeList.size() == 0) {
                        result[0] = null;
                    } else {
                        Object[] resourceSummaryNodes = new Object[resourceSummaryNodeList.size()];
                        resourceSummaryNodeList.toArray(resourceSummaryNodes);
                        Object[] summaryEditionNodes = new Object[summaryEditionNodeList.size()];
                        summaryEditionNodeList.toArray(summaryEditionNodes);
                        MultipleSelectionNode left = new MultipleSelectionNode(resourceSummaryNodes);
                        MultipleSelectionNode right = new MultipleSelectionNode(summaryEditionNodes);
                        result[0] = new SummaryDifferencer().findDifferences(false, monitor, null, null, left, right);
                        this.fRoot = result[0];
                    }
                }
                finally {
                    sub.done();
                    if (client != null) {
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                    }
                }
                if (result[0] instanceof DiffNode && !(diffNode = (DiffNode)result[0]).hasChildren()) {
                    return null;
                }
                Object object = result[0];
                return object;
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (Exception e) {
                String string = e.getMessage();
                return string;
            }
            finally {
                monitor.done();
            }
        }
        SVNLocalResourceNode left = new SVNLocalResourceNode(this.resource);
        ResourceEditionNode right = new ResourceEditionNode(this.remoteResource, this.pegRevision);
        if (left.getType() == "FOLDER") {
            right.setLocalResource(left);
        }
        if (right.getType() == "FOLDER") {
            left.setRemoteResource(right);
        }
        String localCharset = Utilities.getCharset(this.resource.getIResource());
        try {
            right.setCharset(localCharset);
        }
        catch (CoreException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        if (SVNRevision.BASE.equals((Object)this.remoteRevision)) {
            this.fRoot = new StatusAwareDifferencer().findDifferences(false, monitor, null, null, (Object)left, right);
            return this.fRoot;
        }
        this.fRoot = new RevisionAwareDifferencer(left, right, this.diffFile, this.pegRevision).findDifferences(false, monitor, null, null, (Object)left, right);
        return this.fRoot;
    }

    private void getUnadded(ISVNClientAdapter client, ISVNLocalResource resource, File file) throws SVNClientException, SVNException {
        IResource[] unaddedResources;
        ISVNStatus[] statuses;
        ISVNStatus[] iSVNStatusArray = statuses = client.getStatus(file, true, true);
        int n = 0;
        int n2 = iSVNStatusArray.length;
        while (n < n2) {
            ISVNLocalResource localResource;
            ISVNStatus status = iSVNStatusArray[n];
            IResource currentResource = SVNWorkspaceRoot.getResourceFor((IResource)resource.getResource(), (ISVNStatus)status);
            if (!(currentResource == null || (localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)currentResource)).isIgnored() || SVNStatusUtils.isManaged((ISVNStatus)status) || this.isSymLink(currentResource))) {
                if (currentResource.getType() != 1) {
                    this.unversionedFolders.add(currentResource);
                } else if (this.addToUnadded(currentResource)) {
                    this.unaddedList.add(currentResource);
                }
            }
            ++n;
        }
        IResource[] iResourceArray = unaddedResources = this.getUnaddedResources(this.unversionedFolders);
        n2 = 0;
        int n3 = iResourceArray.length;
        while (n2 < n3) {
            IResource unaddedResource = iResourceArray[n2];
            this.unaddedList.add(unaddedResource);
            ++n2;
        }
    }

    private SVNDiffSummary[] getDiffSummaryWithSubfolders(SVNDiffSummary[] diffSummary) {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<SVNDiffSummary> diffs = new ArrayList<SVNDiffSummary>();
        int i = 0;
        while (i < diffSummary.length) {
            paths.add(diffSummary[i].getPath());
            diffs.add(diffSummary[i]);
            ++i;
        }
        i = 0;
        while (i < diffSummary.length) {
            File file = new File(diffSummary[i].getPath());
            while (file.getParentFile() != null) {
                file = file.getParentFile();
                String path = file.getPath();
                if (paths.contains(path = path.replaceAll("\\\\", "/"))) continue;
                paths.add(path);
                SVNDiffSummary folder = new SVNDiffSummary(path, SVNDiffSummary.SVNDiffKind.NORMAL, false, SVNNodeKind.DIR.toInt());
                diffs.add(folder);
            }
            ++i;
        }
        diffSummary = new SVNDiffSummary[diffs.size()];
        diffs.toArray(diffSummary);
        return diffSummary;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                SVNLocalCompareInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    SVNLocalCompareInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setDiffOperation(ShowDifferencesAsUnifiedDiffOperationWC diffOperation) {
        this.diffOperation = diffOperation;
    }

    public void setDiffFile(File diffFile) {
        this.diffFile = diffFile;
    }

    public boolean canRunAsJob() {
        return true;
    }

    private IResource[] getUnaddedResources(List resources) throws SVNException {
        final ArrayList unadded = new ArrayList();
        final SVNException[] exception = new SVNException[1];
        for (IResource resource : resources) {
            if (!resource.exists()) continue;
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource aResource) {
                        block6: {
                            ISVNLocalResource svnResource;
                            block5: {
                                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)aResource);
                                if (!svnResource.isIgnored()) break block5;
                                return false;
                            }
                            if (!svnResource.isManaged()) break block6;
                            return true;
                        }
                        try {
                            if (aResource.getType() == 2 && SVNLocalCompareInput.this.isSymLink(aResource)) {
                                return false;
                            }
                        }
                        catch (SVNException e) {
                            exception[0] = e;
                        }
                        unadded.add(aResource);
                        return aResource.getType() == 2;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                throw SVNException.wrapException((CoreException)e);
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    private boolean isSymLink(IResource resource) {
        File file;
        block3: {
            file = resource.getLocation().toFile();
            try {
                if (file.exists()) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        String cnnpath = file.getCanonicalPath();
        String abspath = file.getAbsolutePath();
        return !abspath.equals(cnnpath);
    }

    private boolean addToUnadded(IResource resource) {
        IResource parent = resource;
        while (parent != null) {
            if (!this.unaddedList.contains(parent = parent.getParent())) continue;
            return false;
        }
        return true;
    }
}

