/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.BranchTagOperation;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.SizePersistedWizardDialog;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            BranchTagWizard wizard = new BranchTagWizard(resources);
            SizePersistedWizardDialog dialog = new SizePersistedWizardDialog(this.getShell(), (IWizard)wizard, "BranchTag");
            wizard.setParentDialog(dialog);
            if (dialog.open() == 0) {
                SVNUrl[] sourceUrls = wizard.getUrls();
                SVNUrl destinationUrl = wizard.getToUrl();
                String message = wizard.getComment();
                boolean createOnServer = wizard.isCreateOnServer();
                BranchTagOperation branchTagOperation = new BranchTagOperation(this.getTargetPart(), this.getSelectedResources(), sourceUrls, destinationUrl, createOnServer, wizard.getRevision(), message);
                branchTagOperation.setMakeParents(wizard.isMakeParents());
                branchTagOperation.setMultipleTransactions(wizard.isSameStructure());
                branchTagOperation.setNewAlias(wizard.getNewAlias());
                branchTagOperation.switchAfterTagBranchOperation(wizard.isSwitchAfterBranchTag());
                branchTagOperation.setSvnExternals(wizard.getSvnExternals());
                branchTagOperation.run();
            }
        }
    }

    protected String getErrorTitle() {
        return Policy.bind("BranchTagAction.branch");
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabledForMultipleResources() {
        try {
            ISVNRepositoryLocation repository = null;
            IResource[] selectedResources = this.getSelectedResources();
            int i = 0;
            while (true) {
                if (i >= selectedResources.length) {
                    return true;
                }
                ISVNRepositoryLocation compareToRepository = null;
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)selectedResources[i]);
                if (svnResource == null) return false;
                if (!svnResource.isManaged()) {
                    return false;
                }
                LocalResourceStatus status = svnResource.getStatusFromCache();
                if (status != null) {
                    compareToRepository = status.getRepository();
                }
                if (compareToRepository == null) {
                    return false;
                }
                if (repository != null && !compareToRepository.equals(repository)) {
                    return false;
                }
                repository = compareToRepository;
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Branch/Tag";
    }
}

