/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;

public class DocumentUtil {
    public static IPath getLocation(IDocument doc) {
        ITextFileBuffer buf;
        ITextFileBufferManager bufferMgr = FileBuffers.getTextFileBufferManager();
        if (bufferMgr != null && (buf = bufferMgr.getTextFileBuffer(doc)) != null) {
            return buf.getLocation();
        }
        return null;
    }

    public static IProject getProject(IDocument doc) {
        IPath location = DocumentUtil.getLocation(doc);
        if (location != null && location.segmentCount() >= 1) {
            String projectName = location.segment(0);
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    public static IJavaProject getJavaProject(IDocument doc) {
        try {
            IProject p;
            if (doc != null && (p = DocumentUtil.getProject(doc)) != null && p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)p);
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    public static int firstNonWhitespaceCharOfRegion(IDocument doc, IRegion region) {
        try {
            int pos = SpringPropertiesCompletionEngine.skipWhiteSpace(doc, region.getOffset());
            if (pos < region.getOffset() + region.getLength()) {
                return pos;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return -1;
    }

    public static int lastNonWhitespaceCharOfRegion(IDocument doc, IRegion errorRegion) {
        try {
            int pos = errorRegion.getOffset() + errorRegion.getLength() - 1;
            while (pos >= errorRegion.getOffset() && Character.isWhitespace(doc.getChar(pos))) {
                --pos;
            }
            if (pos >= errorRegion.getOffset()) {
                return pos;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return -1;
    }
}

