/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.util.AnnotationServiceLocator;
import org.springframework.ide.eclipse.boot.util.JavaProjectUtil;

public class AptUtils {
    public static void configureApt(IJavaProject jp) {
        boolean shouldEnable = false;
        try {
            IFactoryPath factoryPath = AptConfig.getDefaultFactoryPath((IJavaProject)jp);
            for (File jarFile : JavaProjectUtil.getNonSystemJarDependencies((IJavaProject)jp, (boolean)true)) {
                Path absolutePath;
                IPath variablePath;
                if (!AnnotationServiceLocator.getAptServiceEntries(jarFile).isEmpty()) {
                    shouldEnable = true;
                }
                if ((variablePath = AptUtils.useClasspathVariable((IPath)(absolutePath = new Path(jarFile.getAbsolutePath())))) != null) {
                    factoryPath.addVarJar(variablePath);
                    continue;
                }
                factoryPath.addExternalJar(jarFile);
            }
            if (shouldEnable) {
                AptConfig.setEnabled((IJavaProject)jp, (boolean)true);
                AptConfig.setFactoryPath((IJavaProject)jp, (IFactoryPath)factoryPath);
            } else {
                AptConfig.setEnabled((IJavaProject)jp, (boolean)false);
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
    }

    public static boolean isAptEnabled(IJavaProject jp) {
        if (jp != null) {
            return AptConfig.isEnabled((IJavaProject)jp);
        }
        return false;
    }

    private static IPath useClasspathVariable(IPath absolutePath) {
        String bestVar = null;
        int bestLen = 0;
        String[] stringArray = JavaCore.getClasspathVariableNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            IPath varPath = JavaCore.getClasspathVariable((String)var);
            if (varPath != null && varPath.segmentCount() > bestLen && varPath.isPrefixOf(absolutePath)) {
                bestVar = var;
                bestLen = varPath.segmentCount();
            }
            ++n2;
        }
        if (bestVar != null) {
            IPath varPath = JavaCore.getClasspathVariable(bestVar);
            IPath relativePath = absolutePath.removeFirstSegments(varPath.segmentCount());
            return new Path(bestVar).append(relativePath);
        }
        return null;
    }
}

