/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AnnotationServiceLocator {
    private static final String JAVA5_FACTORY_NAME = "com.sun.mirror.apt.AnnotationProcessorFactory";
    private static final String JAVA6_FACTORY_NAME = "javax.annotation.processing.Processor";
    private static final String[] APT_SERVICES = new String[]{"com.sun.mirror.apt.AnnotationProcessorFactory", "javax.annotation.processing.Processor"};

    public static Set<ServiceEntry> getAptServiceEntries(File jar) throws IOException {
        HashSet<ServiceEntry> hashSet;
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Null %s.", File.class));
        }
        if (!jar.exists()) {
            throw new IllegalArgumentException(String.format("Specified file does not exist: %s", jar.getAbsolutePath()));
        }
        if (!jar.canRead()) {
            throw new IllegalArgumentException(String.format("Specified file not readable: %s", jar.getAbsolutePath()));
        }
        HashSet<ServiceEntry> serviceEntries = new HashSet<ServiceEntry>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            String[] stringArray = APT_SERVICES;
            int n = APT_SERVICES.length;
            int n2 = 0;
            while (n2 < n) {
                String serviceName = stringArray[n2];
                String providerName = "META-INF/services/" + serviceName;
                JarEntry provider = jarFile.getJarEntry(providerName);
                if (provider != null) {
                    InputStream is = jarFile.getInputStream(provider);
                    Set<ServiceEntry> serviceFileEntries = AnnotationServiceLocator.readServiceProvider(serviceName, is);
                    serviceEntries.addAll(serviceFileEntries);
                }
                ++n2;
            }
            hashSet = serviceEntries;
        }
        catch (Throwable throwable) {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return hashSet;
    }

    private static Set<ServiceEntry> readServiceProvider(String serviceName, InputStream servicesDeclarationFile) throws IOException {
        HashSet<ServiceEntry> hashSet;
        block10: {
            HashSet<ServiceEntry> serviceEntries = new HashSet<ServiceEntry>();
            BufferedReader servicesReader = null;
            try {
                servicesReader = new BufferedReader(new InputStreamReader(servicesDeclarationFile, "UTF-8"));
                String line = servicesReader.readLine();
                while (line != null) {
                    String[] tokens;
                    int iComment = line.indexOf(35);
                    if (iComment >= 0) {
                        line = line.substring(0, iComment);
                    }
                    if ((tokens = line.split("\\s", 2))[0].length() > 0) {
                        ServiceEntry serviceEntry = new ServiceEntry(serviceName, tokens[0]);
                        serviceEntries.add(serviceEntry);
                    }
                    line = servicesReader.readLine();
                }
                hashSet = serviceEntries;
                if (servicesReader == null) break block10;
            }
            catch (Throwable throwable) {
                if (servicesReader != null) {
                    try {
                        servicesReader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                servicesReader.close();
            }
            catch (IOException iOException) {}
        }
        return hashSet;
    }

    public static final class ServiceEntry {
        private final String serviceName;
        private final String serviceProviderClassName;

        public ServiceEntry(String serviceName, String serviceProviderClassName) {
            this.serviceName = serviceName;
            this.serviceProviderClassName = serviceProviderClassName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceProviderClassName() {
            return this.serviceProviderClassName;
        }
    }
}

