/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.core.monitoring.Monitoring;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooRepositoryConnector;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildPlanManager;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedEvent;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedListener;
import com.atlassian.connector.eclipse.internal.core.AtlassianLogger;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class BambooCorePlugin
extends Plugin {
    private static final String REPOSITORY_CONFIGURATIONS_FOLDER_PATH = "repositoryConfigurations";
    public static final String PLUGIN_ID = "com.atlassian.connector.eclipse.bamboo.core";
    public static final String CONNECTOR_KIND = "bamboo";
    private static BambooRepositoryConnector repositoryConnector;
    private static BambooCorePlugin plugin;
    private static BuildPlanManager buildPlanManager;
    private static Monitoring monitoring;

    static {
        monitoring = null;
    }

    public BambooCorePlugin() {
        LoggerImpl.setInstance((Logger)new AtlassianLogger());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IEclipsePreferences preferences = new DefaultScope().getNode(PLUGIN_ID);
        preferences.putInt("prefs_refresh_interval", 15);
        preferences.putBoolean("pref_auto_refresh", true);
        buildPlanManager = new BuildPlanManager();
        preferences = new InstanceScope().getNode(PLUGIN_ID);
        preferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("pref_auto_refresh") && BambooCorePlugin.isAutoRefresh()) {
                    buildPlanManager.refreshAllBuilds();
                }
                buildPlanManager.reInitializeScheduler();
            }
        });
        buildPlanManager.addBuildsChangedListener(new BuildsChangedListener(){

            public void buildsUpdated(BuildsChangedEvent event) {
                BambooUtil.runActionForChangedBuild(event, new BambooUtil.BuildChangeAction(){

                    public void run(BambooBuild build, TaskRepository repository) {
                        String sound;
                        IEclipsePreferences preferences;
                        boolean isPlaySound;
                        if (build.getStatus() == BuildStatus.FAILURE && (isPlaySound = (preferences = new InstanceScope().getNode(BambooCorePlugin.PLUGIN_ID)).getBoolean("prefs_play_sound_build_failed", false)) && (sound = preferences.get("pref_sound_build_failed", "")) != null) {
                            sound.length();
                        }
                    }
                });
            }
        });
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void stop(BundleContext context) throws Exception {
        if (repositoryConnector != null) {
            repositoryConnector.flush();
        }
        plugin = null;
        super.stop(context);
    }

    public static BambooCorePlugin getDefault() {
        return plugin;
    }

    public static void setRepositoryConnector(BambooRepositoryConnector repositoryConnector) {
        BambooCorePlugin.repositoryConnector = repositoryConnector;
    }

    public static BambooRepositoryConnector getRepositoryConnector() {
        return repositoryConnector;
    }

    public File getRepositoryConfigurationCacheFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        IPath cacheFile = stateLocation.append(REPOSITORY_CONFIGURATIONS_FOLDER_PATH);
        return cacheFile.toFile();
    }

    public static BuildPlanManager getBuildPlanManager() {
        return buildPlanManager;
    }

    public static int getRefreshIntervalMinutes() {
        int minutes = new InstanceScope().getNode(PLUGIN_ID).getInt("prefs_refresh_interval", 15);
        return minutes;
    }

    public static void setRefreshIntervalMinutes(int minutes) {
        IEclipsePreferences preferences = new InstanceScope().getNode(PLUGIN_ID);
        preferences.putInt("prefs_refresh_interval", minutes);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void toggleAutoRefresh() {
        IEclipsePreferences preferences = new InstanceScope().getNode(PLUGIN_ID);
        preferences.putBoolean("pref_auto_refresh", !BambooCorePlugin.isAutoRefresh());
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static boolean isAutoRefresh() {
        IEclipsePreferences preferences = new InstanceScope().getNode(PLUGIN_ID);
        return preferences.getBoolean("pref_auto_refresh", true);
    }

    public static Monitoring getMonitoring() {
        if (monitoring == null) {
            monitoring = new Monitoring(PLUGIN_ID);
        }
        return monitoring;
    }
}

