/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.aop;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PointcutReferenceContentAssistCalculator
implements IContentAssistCalculator {
    private static final int RELEVANCE = 20;

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        this.addPointcutReferenceProposals(context, recorder);
    }

    private void addPointcutReferenceProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String prefix = context.getMatchString();
        if (prefix == null) {
            prefix = "";
        }
        IFile file = context.getFile();
        if (context.getDocument() != null) {
            this.searchPointcutElements(recorder, prefix, context.getParentNode(), file);
            this.searchPointcutElements(recorder, prefix, context.getParentNode().getParentNode(), file);
        }
    }

    private void searchPointcutElements(IContentAssistProposalRecorder recorder, String prefix, Node node, IFile file) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap attributes;
            Node idAttribute;
            Node child = children.item(i);
            if ("pointcut".equals(child.getLocalName()) && (idAttribute = (attributes = child.getAttributes()).getNamedItem("id")) != null && idAttribute.getNodeValue() != null && idAttribute.getNodeValue().startsWith(prefix)) {
                this.acceptSearchMatch(recorder, child, file);
            }
            ++i;
        }
    }

    public void acceptSearchMatch(IContentAssistProposalRecorder recorder, Node pointcutNode, IFile file) {
        String pointcutName;
        NamedNodeMap attributes = pointcutNode.getAttributes();
        Node idAttribute = attributes.getNamedItem("id");
        Node parentNode = pointcutNode.getParentNode();
        String replaceText = pointcutName = idAttribute.getNodeValue();
        String fileName = file.getProjectRelativePath().toString();
        StringBuilder buf = new StringBuilder();
        buf.append(pointcutName);
        if (parentNode != null) {
            buf.append(" [");
            buf.append(parentNode.getNodeName());
            buf.append("]");
        }
        if (fileName != null) {
            buf.append(" - ");
            buf.append(fileName);
        }
        String displayText = buf.toString();
        Image image = BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.pointcut_obj.gif");
        recorder.recordProposal(image, 20, displayText, replaceText, pointcutName);
    }
}

