/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeanReferenceContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansCompletionUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class PropertyBeanReferenceContentAssistCalculator
extends BeanReferenceContentAssistCalculator {
    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        BeansCompletionUtils.addBeanReferenceProposals(context, recorder, this.showExternal, this.calculateType(context, recorder));
    }

    protected List<String> calculateType(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        if (context.getParentNode() != null && "bean".equals(context.getParentNode().getLocalName())) {
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), context.getParentNode());
            if (file != null && file.exists()) {
                IType type = JdtUtils.getJavaType((IProject)context.getFile().getProject(), (String)className);
                String propertyName = BeansEditorUtils.getAttribute(context.getNode(), "name");
                if (propertyName != null) {
                    try {
                        String parameterTypeName;
                        IMethod method = Introspector.getWritableProperty((IType)type, (String)propertyName);
                        if (method != null && (parameterTypeName = JdtUtils.resolveClassNameBySignature((String)method.getParameterTypes()[0], (IType)type)) != null) {
                            IType parameterType = JdtUtils.getJavaType((IProject)context.getFile().getProject(), (String)parameterTypeName);
                            return JdtUtils.getFlatListOfClassAndInterfaceNames((IType)parameterType, (IType)type);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        return Collections.emptyList();
    }
}

