/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import org.springsource.ide.eclipse.commons.core.process.OutputWriter;
import org.springsource.ide.eclipse.commons.core.process.ProcessRunner;

public final class StandardProcessRunner
implements ProcessRunner {
    private static final String[] ENVIRONMENT = new String[]{String.format("JAVA_HOME=%s", System.getProperty("java.home")), String.format("PATH=%s", System.getenv("PATH")), String.format("USERDOMAIN=%s", System.getenv("USERDOMAIN")), String.format("USERNAME=%s", System.getenv("USERNAME")), String.format("USERPROFILE=%s", System.getenv("USERPROFILE"))};
    private final OutputWriter[] standardOutputWriters;
    private final OutputWriter[] standardErrorWriters;

    public StandardProcessRunner() {
        this(new OutputWriter[0], new OutputWriter[0]);
    }

    public StandardProcessRunner(OutputWriter standardOutputWriter, OutputWriter standardErrorWriter) {
        this(new OutputWriter[]{standardOutputWriter}, new OutputWriter[]{standardErrorWriter});
    }

    public StandardProcessRunner(OutputWriter[] standardOutputWriters, OutputWriter[] standardErrorWriters) {
        this.standardOutputWriters = standardOutputWriters;
        this.standardErrorWriters = standardErrorWriters;
    }

    @Override
    public int run(File workingDir, String ... command) throws IOException, InterruptedException {
        Process process = command.length == 1 ? Runtime.getRuntime().exec(command[0], ENVIRONMENT, workingDir) : Runtime.getRuntime().exec(command, ENVIRONMENT, workingDir);
        CountDownLatch latch = new CountDownLatch(2);
        new Thread(new StreamReader(process.getInputStream(), this.standardOutputWriters, latch)).start();
        new Thread(new StreamReader(process.getErrorStream(), this.standardErrorWriters, latch)).start();
        int returnCode = process.waitFor();
        latch.await();
        return returnCode;
    }

    private static final class StreamReader
    implements Runnable {
        private final BufferedReader input;
        private final OutputWriter[] outputs;
        private final CountDownLatch latch;

        public StreamReader(InputStream input, OutputWriter[] outputs, CountDownLatch latch) {
            this.input = new BufferedReader(new InputStreamReader(input));
            this.outputs = outputs;
            this.latch = latch;
        }

        @Override
        public void run() {
            block24: {
                try {
                    try {
                        String line = null;
                        while ((line = this.input.readLine()) != null) {
                            OutputWriter[] outputWriterArray = this.outputs;
                            int n = this.outputs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                OutputWriter output = outputWriterArray[n2];
                                output.write(line);
                                ++n2;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            try {
                                if (this.input != null) {
                                    this.input.close();
                                }
                                break block24;
                            }
                            catch (IOException iOException2) {
                                this.latch.countDown();
                            }
                            break block24;
                        }
                        finally {
                            this.latch.countDown();
                        }
                    }
                }
                catch (Throwable throwable) {
                    block26: {
                        try {
                            try {
                                if (this.input != null) {
                                    this.input.close();
                                }
                            }
                            catch (IOException iOException) {
                                this.latch.countDown();
                                break block26;
                            }
                        }
                        catch (Throwable throwable2) {
                            this.latch.countDown();
                            throw throwable2;
                        }
                        this.latch.countDown();
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (this.input != null) {
                            this.input.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.latch.countDown();
                    }
                }
                finally {
                    this.latch.countDown();
                }
            }
        }
    }
}

