/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.ITaskAttributeMapper2;
import com.atlassian.connector.eclipse.internal.jira.core.JiraField;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.TaskSchema;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkLogConverter {
    private static List<JiraField<?>> _taskFields = new ArrayList();
    public static final JiraField<IRepositoryPerson> AUTOR = WorkLogConverter.create(IRepositoryPerson.class, "author", Messages.WorkLogConverter_Author, "person");
    public static final JiraField<String> COMMENT = WorkLogConverter.create(String.class, "comment", Messages.WorkLogConverter_Comment, "longText");
    public static final JiraField<Date> CREATION_DATE = WorkLogConverter.create(Date.class, "created", Messages.WorkLogConverter_Created, "dateTime");
    public static final JiraField<String> GROUP_LEVEL = WorkLogConverter.create(String.class, "groupLevel", Messages.WorkLogConverter_Group_Level, "dateTime");
    public static final JiraField<String> ID = WorkLogConverter.create(String.class, "id", Messages.WorkLogConverter_Id, "shortText");
    public static final JiraField<Date> MODIFICATION_DATE = WorkLogConverter.create(Date.class, "updated", Messages.WorkLogConverter_Updated, "dateTime");
    public static final String PREFIX_WORKLOG = "attribute.jira.worklog-";
    public static final String ATTRIBUTE_WORKLOG_NEW = "attribute.jira.worklog.new";
    public static final String ATTRIBUTE_WORKLOG_NEW_SUBMIT_FLAG = "attribute.jira.worklog.new.submit.flag";
    public static final JiraField<String> ROLE_LEVEL_ID = WorkLogConverter.create(String.class, "roleLevelId", Messages.WorkLogConverter_Role_Level, "shortText");
    public static final JiraField<Date> START_DATE = WorkLogConverter.create(Date.class, "startDate", Messages.WorkLogConverter_Start_Date, "dateTime");
    public static final JiraField<Long> TIME_SPENT = WorkLogConverter.create(Long.class, "timeSpent", Messages.WorkLogConverter_Time, "long");
    public static final String TYPE_WORKLOG = "jira.worklog";
    public static final JiraField<IRepositoryPerson> UPDATE_AUTHOR = WorkLogConverter.create(IRepositoryPerson.class, "updateAuthor", Messages.WorkLogConverter_Author, "person");
    private static final String ADJUST_ESTIMATE_KEY = "attribute.jira.worklog.adjustEstimate";
    private final List<? extends TaskSchema.TaskField<?>> fields = WorkLogConverter.taskFields();

    private static <T> JiraField<T> create(Class<T> clazz, String key, String label, String type) {
        JiraField<T> field = new JiraField<T>(clazz, "attribute.jira.worklog." + key, key, label, type);
        _taskFields.add(field);
        return field;
    }

    public static List<JiraField<?>> taskFields() {
        return Collections.unmodifiableList(_taskFields);
    }

    protected JiraWorkLog newInstance() {
        return new JiraWorkLog();
    }

    public JiraWorkLog createFrom(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        JiraWorkLog instance = this.newInstance();
        for (TaskSchema.TaskField<?> field : this.fields) {
            TaskAttribute child = taskAttribute.getAttribute(field.key());
            if (child == null) continue;
            this.setJavaField(instance, field, child);
        }
        TaskAttribute child = taskAttribute.getAttribute(ADJUST_ESTIMATE_KEY);
        if (child != null) {
            instance.setAdjustEstimate(JiraWorkLog.AdjustEstimateMethod.fromValue(child.getValue()));
        } else {
            instance.setAdjustEstimate(JiraWorkLog.AdjustEstimateMethod.AUTO);
        }
        return instance;
    }

    public void applyTo(JiraWorkLog instance, TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        for (TaskSchema.TaskField<?> field : this.fields) {
            TaskAttribute child = this.addAttribute(taskAttribute, field);
            this.setAttributeValue(instance, field, child);
        }
        if (instance.getAdjustEstimate() != null) {
            TaskAttribute child = this.addAttribute(taskAttribute, new JiraField<String>(String.class, ADJUST_ESTIMATE_KEY, "adjustEstimate", "Adjust Estimate", "shortText"));
            child.setValue(instance.getAdjustEstimate().value());
        }
    }

    private boolean setJavaField(JiraWorkLog instance, TaskSchema.TaskField<?> taskField, TaskAttribute attribute) {
        if (taskField.javaKey() != null) {
            try {
                Object value;
                Field field = instance.getClass().getDeclaredField(taskField.javaKey());
                field.setAccessible(true);
                TaskAttributeMapper mapper = attribute.getTaskData().getAttributeMapper();
                if ("date".equals(taskField.getType())) {
                    value = mapper.getDateValue(attribute);
                } else if ("dateTime".equals(taskField.getType())) {
                    value = mapper.getDateValue(attribute);
                } else if ("integer".equals(taskField.getType())) {
                    value = mapper.getIntegerValue(attribute);
                    if (value == null) {
                        value = 0;
                    }
                } else if ("long".equals(taskField.getType())) {
                    value = mapper.getLongValue(attribute);
                    if (value == null) {
                        value = 0;
                    }
                } else if ("boolean".equals(taskField.getType())) {
                    value = mapper.getBooleanValue(attribute);
                    if (value == null) {
                        value = false;
                    }
                } else {
                    value = attribute.getValue();
                }
                field.set(instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean setAttributeValue(JiraWorkLog instance, TaskSchema.TaskField<?> taskField, TaskAttribute attribute) {
        try {
            Field field = instance.getClass().getDeclaredField(taskField.javaKey());
            field.setAccessible(true);
            Object value = field.get(instance);
            TaskAttributeMapper mapper = attribute.getTaskData().getAttributeMapper();
            if (value == null) {
                attribute.clearValues();
            } else if ("date".equals(taskField.getType())) {
                mapper.setDateValue(attribute, (Date)value);
            } else if ("dateTime".equals(taskField.getType())) {
                mapper.setDateValue(attribute, (Date)value);
            } else if ("integer".equals(taskField.getType())) {
                mapper.setIntegerValue(attribute, (Integer)value);
            } else if ("long".equals(taskField.getType())) {
                mapper.setLongValue(attribute, (Long)value);
            } else {
                attribute.setValue(value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public TaskAttribute addAttribute(TaskAttribute parent, TaskSchema.TaskField<?> field) {
        TaskAttribute attribute = parent.createAttribute(field.key());
        TaskAttributeMetaData metaData = attribute.getMetaData();
        metaData.setLabel(field.getLabel());
        metaData.setType(field.getType());
        metaData.setReadOnly(field.isReadOnly());
        metaData.setKind(field.getKind());
        Map<String, String> options = ((ITaskAttributeMapper2)parent.getTaskData().getAttributeMapper()).getRepositoryOptions(attribute);
        if (options != null) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                attribute.putOption(option.getKey(), option.getValue());
            }
        }
        return attribute;
    }
}

