/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.springframework.ide.eclipse.webflow.core.internal.model.IfTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AddTransitionActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteIfTransitionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteStateTransitionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.SplitIfTransitionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.SplitStateTransitionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.IfTransitionPart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;

public class TransitionEditPolicy
extends ConnectionEditPolicy {
    public void eraseTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            this.getConnectionFigure().setLineWidth(1);
        }
    }

    public Command getCommand(Request request) {
        if ("create child".equals(request.getType())) {
            return this.getSplitTransitionCommand(request);
        }
        if ("Edit_propeties".equals(request.getType())) {
            return this.getEditPropertiesCommand();
        }
        return super.getCommand(request);
    }

    private PolylineConnection getConnectionFigure() {
        if (this.getHost() instanceof StateTransitionPart) {
            return (PolylineConnection)((StateTransitionPart)this.getHost()).getFigure();
        }
        if (this.getHost() instanceof IfTransitionPart) {
            return (PolylineConnection)((IfTransitionPart)this.getHost()).getFigure();
        }
        return null;
    }

    protected Command getDeleteCommand(GroupRequest request) {
        IfTransition t;
        if (this.getHost().getModel() instanceof StateTransition) {
            DeleteStateTransitionCommand cmd = new DeleteStateTransitionCommand();
            StateTransition t2 = (StateTransition)this.getHost().getModel();
            cmd.setTransition((IStateTransition)t2);
            cmd.setSource(t2.getFromState());
            cmd.setTarget(t2.getToState());
            return cmd;
        }
        if (this.getHost().getModel() instanceof IfTransition && !(t = (IfTransition)this.getHost().getModel()).isThen()) {
            DeleteIfTransitionCommand cmd = new DeleteIfTransitionCommand();
            cmd.setTransition((IIfTransition)t);
            cmd.setSource(t.getFromIf());
            cmd.setTarget(t.getToState());
            return cmd;
        }
        return null;
    }

    protected Command getEditPropertiesCommand() {
        EditPropertiesCommand command = new EditPropertiesCommand();
        command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)this.getHost().getModel()));
        return command;
    }

    protected Command getSplitTransitionCommand(Request request) {
        IActionElement action;
        if (((CreateRequest)request).getNewObject() instanceof IState) {
            if (this.getHost().getModel() instanceof IStateTransition) {
                SplitStateTransitionCommand cmd = new SplitStateTransitionCommand();
                cmd.setTransition((IStateTransition)this.getHost().getModel());
                cmd.setParent((IWebflowState)((StateTransitionPart)this.getHost()).getSource().getParent().getModel());
                cmd.setNewActivity((IState)((CreateRequest)request).getNewObject());
                return cmd;
            }
            if (this.getHost().getModel() instanceof IIfTransition) {
                SplitIfTransitionCommand cmd = new SplitIfTransitionCommand();
                cmd.setTransition((IIfTransition)this.getHost().getModel());
                cmd.setParent((IWebflowState)((IfTransitionPart)this.getHost()).getTarget().getParent().getModel());
                cmd.setNewActivity((IState)((CreateRequest)request).getNewObject());
                return cmd;
            }
        } else if (((CreateRequest)request).getNewObject() instanceof IActionElement && this.getHost().getModel() instanceof IStateTransition && (action = (IActionElement)((CreateRequest)request).getNewObject()).getType() == IActionElement.ACTION_TYPE.ACTION) {
            AddTransitionActionCommand cmd = new AddTransitionActionCommand();
            cmd.setTransition((IStateTransition)this.getHost().getModel());
            cmd.setNewAction((IActionElement)((CreateRequest)request).getNewObject());
            return cmd;
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("create child".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    public void showTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            this.getConnectionFigure().setLineWidth(2);
        }
    }
}

