/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.springframework.ide.eclipse.webflow.core.internal.model.Import;
import org.springframework.ide.eclipse.webflow.core.model.IImport;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ImportContentProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ImportEditorDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.TableCellModifier;

public class ImportComposite {
    private IWebflowState state;
    private Button removeButton;
    private Button addButton;
    private Button editButton;
    private TableViewer configsViewer;
    private IDialogValidator validator;
    private Shell parentShell;

    public ImportComposite(IDialogValidator validator, TabItem item, Shell parentShell, IWebflowState state) {
        this.state = state;
        item.setText("Imports");
        item.setToolTipText("Define imports");
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.import_obj.gif"));
        this.parentShell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Group groupPropertyType = new Group(parent, 0);
        GridLayout layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 3;
        layoutPropMap.marginHeight = 3;
        groupPropertyType.setLayout((Layout)layoutPropMap);
        groupPropertyType.setText(" Bean Imports ");
        groupPropertyType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupPropertyType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 150;
        configsTable.setLayoutData((Object)data);
        TableColumn columnName = new TableColumn(configsTable, 0);
        columnName.setText("Resource");
        columnName.setWidth(150);
        configsTable.setHeaderVisible(true);
        this.configsViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"Resource"};
        this.configsViewer.setColumnProperties(columnNames);
        this.configsViewer.setContentProvider((IContentProvider)new ImportContentProvider(this.state, this.configsViewer));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.configsViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.configsViewer.setInput((Object)this.state);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportComposite.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText("Add");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.addButton.setLayoutData((Object)data1);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Import property = new Import();
                property.createNew((IWebflowModelElement)ImportComposite.this.state);
                ImportEditorDialog dialog = new ImportEditorDialog(ImportComposite.this.parentShell, (IImport)property);
                if (dialog.open() == 0) {
                    ImportComposite.this.state.addImport((IImport)property);
                    ImportComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ImportComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IImport) {
                    ImportEditorDialog dialog = new ImportEditorDialog(ImportComposite.this.parentShell, (IImport)selection.getFirstElement());
                    dialog.open();
                    ImportComposite.this.configsViewer.refresh(true);
                }
            }
        });
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("Delete");
        GridData data2 = new GridData(256);
        data1.widthHint = 40;
        this.removeButton.setLayoutData((Object)data2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ImportComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IImport) {
                    ImportComposite.this.state.removeImport((IImport)selection.getFirstElement());
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        return groupPropertyType;
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }
}

