/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorInputFactory;

public class WebflowEditorInput
implements IEditorInput,
IPersistableElement {
    private IWebflowConfig config;
    private boolean isValid = true;
    private String name;
    private String tooltip;
    private Map<IDOMNode, Integer> nodesToLineNumbers;

    public WebflowEditorInput(IWebflowConfig config) {
        this.config = config;
        this.tooltip = config.getResource().getFullPath().makeRelative().toString();
        this.name = config.getResource().getFullPath().makeRelative().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebflowEditorInput) {
            return ((WebflowEditorInput)obj).getFile().equals((Object)this.getFile());
        }
        return false;
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return this.config.getResource().getAdapter(adapter);
    }

    public IWebflowConfig getConfig() {
        return this.config;
    }

    public String getFactoryId() {
        return WebflowEditorInputFactory.getFactoryId();
    }

    public IFile getFile() {
        return this.config.getResource();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void saveState(IMemento memento) {
        if (this.isValid) {
            WebflowEditorInputFactory.saveState(memento, this);
        }
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public int getElementStartLine(IDOMNode node) {
        if (this.nodesToLineNumbers.containsKey(node)) {
            return this.nodesToLineNumbers.get(node);
        }
        return 1;
    }

    public void initLineNumbers(IDOMNode root, IDOMNode clone) {
        this.nodesToLineNumbers = WebflowModelXmlUtils.getNodeLineNumbers((IDOMNode)root, (IDOMNode)clone);
    }
}

