/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.util.table;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import net.sf.eclipsecs.ui.util.table.EnhancedTableViewer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class EnhancedCheckBoxTableViewer
extends EnhancedTableViewer
implements ICheckable {
    private final ListenerList checkStateListeners = new ListenerList(3);

    public EnhancedCheckBoxTableViewer(Composite parent) {
        this(parent, 2048);
    }

    public EnhancedCheckBoxTableViewer(Composite parent, int style) {
        this(EnhancedCheckBoxTableViewer.createTable(parent, style));
    }

    public static EnhancedCheckBoxTableViewer newCheckList(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        return new EnhancedCheckBoxTableViewer(table);
    }

    public EnhancedCheckBoxTableViewer(Table table) {
        super(table);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add((Object)listener);
    }

    protected static Table createTable(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        new TableColumn(table, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        return table;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        Object[] array = this.checkStateListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public boolean getGrayed(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getGrayed()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public void handleSelect(SelectionEvent event) {
        if (event.detail == 32) {
            super.handleSelect(event);
            TableItem item = (TableItem)event.item;
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    protected void preservingSelection(Runnable updateCode) {
        Object data;
        TableItem item;
        TableItem[] children = this.getTable().getItems();
        CustomHashtable checked = this.newHashtable(children.length * 2 + 1);
        CustomHashtable grayed = this.newHashtable(children.length * 2 + 1);
        int i = 0;
        while (i < children.length) {
            item = children[i];
            data = item.getData();
            if (data != null) {
                if (item.getChecked()) {
                    checked.put(data, data);
                }
                if (item.getGrayed()) {
                    grayed.put(data, data);
                }
            }
            ++i;
        }
        super.preservingSelection(updateCode);
        children = this.getTable().getItems();
        i = 0;
        while (i < children.length) {
            item = children[i];
            data = item.getData();
            if (data != null) {
                item.setChecked(checked.containsKey(data));
                item.setGrayed(grayed.containsKey(data));
            }
            ++i;
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove((Object)listener);
    }

    public void setAllChecked(boolean state) {
        TableItem[] children = this.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            item.setChecked(state);
            ++i;
        }
    }

    public void setAllGrayed(boolean state) {
        TableItem[] children = this.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            item.setGrayed(state);
            ++i;
        }
    }

    public boolean setChecked(Object element, boolean state) {
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(state);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        CustomHashtable set = this.newHashtable(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            set.put(elements[i], elements[i]);
            ++i;
        }
        TableItem[] items = this.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item = items[i2];
            Object element = item.getData();
            if (element != null) {
                boolean check = set.containsKey(element);
                if (item.getChecked() != check) {
                    item.setChecked(check);
                }
            }
            ++i2;
        }
    }

    public boolean setGrayed(Object element, boolean state) {
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setGrayed(state);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        CustomHashtable set = this.newHashtable(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            set.put(elements[i], elements[i]);
            ++i;
        }
        TableItem[] items = this.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item = items[i2];
            Object element = item.getData();
            if (element != null) {
                boolean gray = set.containsKey(element);
                if (item.getGrayed() != gray) {
                    item.setGrayed(gray);
                }
            }
            ++i2;
        }
    }

    CustomHashtable newHashtable(int capacity) {
        return new CustomHashtable(capacity, this.getComparer());
    }

    static final class CustomHashtable {
        transient int elementCount;
        transient HashMapEntry[] elementData;
        private float loadFactor;
        private int threshold;
        transient int firstSlot = 0;
        transient int lastSlot = -1;
        private final transient IElementComparer comparer;
        private static final EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
        public static final int DEFAULT_CAPACITY = 13;

        public CustomHashtable() {
            this(13);
        }

        public CustomHashtable(int capacity) {
            this(capacity, null);
        }

        public CustomHashtable(IElementComparer comparer) {
            this(13, comparer);
        }

        public CustomHashtable(int capacity, IElementComparer comparer) {
            if (capacity < 0) {
                throw new IllegalArgumentException();
            }
            this.elementCount = 0;
            this.elementData = new HashMapEntry[capacity == 0 ? 1 : capacity];
            this.firstSlot = this.elementData.length;
            this.loadFactor = 0.75f;
            this.computeMaxSize();
            this.comparer = comparer;
        }

        public CustomHashtable(CustomHashtable table, IElementComparer comparer) {
            this(table.size() * 2, comparer);
            int i = table.elementData.length;
            while (--i >= 0) {
                HashMapEntry entry = table.elementData[i];
                while (entry != null) {
                    this.put(entry.key, entry.value);
                    entry = entry.next;
                }
            }
        }

        private void computeMaxSize() {
            this.threshold = (int)((float)this.elementData.length * this.loadFactor);
        }

        public boolean containsKey(Object key) {
            return this.getEntry(key) != null;
        }

        public Enumeration elements() {
            if (this.elementCount == 0) {
                return emptyEnumerator;
            }
            return new HashEnumerator(false);
        }

        public Object get(Object key) {
            int index = (this.hashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            HashMapEntry entry = this.elementData[index];
            while (entry != null) {
                if (this.keyEquals(key, entry.key)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }

        private HashMapEntry getEntry(Object key) {
            int index = (this.hashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            HashMapEntry entry = this.elementData[index];
            while (entry != null) {
                if (this.keyEquals(key, entry.key)) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        private int hashCode(Object key) {
            if (this.comparer == null) {
                return key.hashCode();
            }
            return this.comparer.hashCode(key);
        }

        private boolean keyEquals(Object a, Object b) {
            if (this.comparer == null) {
                return a.equals(b);
            }
            return this.comparer.equals(a, b);
        }

        public Enumeration keys() {
            if (this.elementCount == 0) {
                return emptyEnumerator;
            }
            return new HashEnumerator(true);
        }

        public Object put(Object key, Object value) {
            if (key != null && value != null) {
                int index = (this.hashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
                HashMapEntry entry = this.elementData[index];
                while (entry != null && !this.keyEquals(key, entry.key)) {
                    entry = entry.next;
                }
                if (entry == null) {
                    if (++this.elementCount > this.threshold) {
                        this.rehash();
                        index = (this.hashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
                    }
                    if (index < this.firstSlot) {
                        this.firstSlot = index;
                    }
                    if (index > this.lastSlot) {
                        this.lastSlot = index;
                    }
                    entry = new HashMapEntry(key, value);
                    entry.next = this.elementData[index];
                    this.elementData[index] = entry;
                    return null;
                }
                Object result = entry.value;
                entry.key = key;
                entry.value = value;
                return result;
            }
            throw new NullPointerException();
        }

        private void rehash() {
            int length = this.elementData.length << 1;
            if (length == 0) {
                length = 1;
            }
            this.firstSlot = length;
            this.lastSlot = -1;
            HashMapEntry[] newData = new HashMapEntry[length];
            int i = this.elementData.length;
            while (--i >= 0) {
                HashMapEntry entry = this.elementData[i];
                while (entry != null) {
                    int index = (this.hashCode(entry.key) & Integer.MAX_VALUE) % length;
                    if (index < this.firstSlot) {
                        this.firstSlot = index;
                    }
                    if (index > this.lastSlot) {
                        this.lastSlot = index;
                    }
                    HashMapEntry next = entry.next;
                    entry.next = newData[index];
                    newData[index] = entry;
                    entry = next;
                }
            }
            this.elementData = newData;
            this.computeMaxSize();
        }

        public Object remove(Object key) {
            HashMapEntry last = null;
            int index = (this.hashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            HashMapEntry entry = this.elementData[index];
            while (entry != null && !this.keyEquals(key, entry.key)) {
                last = entry;
                entry = entry.next;
            }
            if (entry != null) {
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                return entry.value;
            }
            return null;
        }

        public int size() {
            return this.elementCount;
        }

        public String toString() {
            if (this.size() == 0) {
                return "{}";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('{');
            int i = this.elementData.length;
            while (--i >= 0) {
                HashMapEntry entry = this.elementData[i];
                while (entry != null) {
                    buffer.append(entry.key);
                    buffer.append('=');
                    buffer.append(entry.value);
                    buffer.append(", ");
                    entry = entry.next;
                }
            }
            if (this.elementCount > 0) {
                buffer.setLength(buffer.length() - 2);
            }
            buffer.append('}');
            return buffer.toString();
        }

        private static final class EmptyEnumerator
        implements Enumeration {
            private EmptyEnumerator() {
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        }

        private class HashEnumerator
        implements Enumeration {
            boolean key;
            int start;
            HashMapEntry entry;

            HashEnumerator(boolean isKey) {
                this.key = isKey;
                this.start = CustomHashtable.this.firstSlot;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasMoreElements() {
                if (this.entry == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    if (CustomHashtable.this.elementData[this.start++] == null) continue;
                    this.entry = CustomHashtable.this.elementData[this.start - 1];
                    return true;
lbl6:
                    // 2 sources

                    ** while (this.start <= CustomHashtable.this.lastSlot)
                }
lbl7:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    Object result = this.key ? this.entry.key : this.entry.value;
                    this.entry = this.entry.next;
                    return result;
                }
                throw new NoSuchElementException();
            }
        }

        private static class HashMapEntry {
            Object key;
            Object value;
            HashMapEntry next;

            HashMapEntry(Object theKey, Object theValue) {
                this.key = theKey;
                this.value = theValue;
            }
        }
    }
}

