/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.filter;

import java.util.HashMap;
import java.util.Map;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.properties.filter.IFilterEditor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class PluginFilterEditors {
    private static final String FILTER_EXTENSION_POINT = "net.sf.eclipsecs.ui.filtereditors";
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_CLASS = "class";
    private static Map<String, Class<? extends IFilterEditor>> sFilterEditorClasses = new HashMap<String, Class<? extends IFilterEditor>>();

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(FILTER_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            try {
                String filter = elements[i].getAttribute(ATTR_FILTER);
                IFilterEditor editor = (IFilterEditor)elements[i].createExecutableExtension(ATTR_CLASS);
                sFilterEditorClasses.put(filter, editor.getClass());
            }
            catch (Exception e) {
                CheckstyleLog.log((Throwable)e);
            }
            ++i;
        }
    }

    private PluginFilterEditors() {
    }

    public static boolean hasEditor(IFilter filter) {
        return sFilterEditorClasses.containsKey(filter.getInternalName());
    }

    public static IFilterEditor getNewEditor(IFilter filter) throws CheckstylePluginException {
        Class<? extends IFilterEditor> editorClass = sFilterEditorClasses.get(filter.getInternalName());
        if (editorClass != null) {
            try {
                IFilterEditor editor = editorClass.newInstance();
                return editor;
            }
            catch (InstantiationException e) {
                CheckstylePluginException.rethrow((Throwable)e);
            }
            catch (IllegalAccessException e) {
                CheckstylePluginException.rethrow((Throwable)e);
            }
            catch (ClassCastException e) {
                CheckstylePluginException.rethrow((Throwable)e);
            }
        }
        return null;
    }
}

