/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.workingsets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.workingsets.IWorkingSetFilter;
import org.springframework.ide.eclipse.ui.workingsets.WorkingSetUtils;

public class WorkingSetsViewerFilter
extends ViewerFilter {
    private static final String WORKING_SET_ID = "org.springframework.ide.eclipse.ui.springWorkingSetPage";
    private IWorkingSet workingSet;

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.workingSet == null) {
            return true;
        }
        if (element != null) {
            IAdaptable[] elements;
            if (WORKING_SET_ID.equals(this.workingSet.getId())) {
                return this.isInWorkingSet(parentElement, element);
            }
            IAdaptable[] iAdaptableArray = elements = this.getElementsFromWorkingSet();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable elem = iAdaptableArray[n2];
                if (elem instanceof IJavaProject) {
                    return SpringCoreUtils.isSpringProject((IResource)((IJavaProject)elem).getProject());
                }
                if (elem instanceof IProject) {
                    return SpringCoreUtils.isSpringProject((IResource)((IProject)elem));
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean isInWorkingSet(Object parentElement, Object element) {
        if (this.workingSet == null) {
            return true;
        }
        if (parentElement instanceof IWorkingSet && element instanceof IWorkingSet) {
            return true;
        }
        for (IWorkingSetFilter filter : WorkingSetUtils.getViewerFilter()) {
            if (!filter.isInWorkingSet(this.getElementsFromWorkingSet(parentElement), parentElement, element)) continue;
            return true;
        }
        return false;
    }

    private IAdaptable[] getElementsFromWorkingSet(Object parentElement) {
        Object firstSegment;
        if (parentElement instanceof TreePath && ((TreePath)parentElement).getFirstSegment() != null && (firstSegment = ((TreePath)parentElement).getFirstSegment()) instanceof IWorkingSet && this.workingSet.isAggregateWorkingSet()) {
            IWorkingSet[] workingSets;
            IWorkingSet[] iWorkingSetArray = workingSets = ((AggregateWorkingSet)this.workingSet).getComponents();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet ws = iWorkingSetArray[n2];
                if (ws.equals(firstSegment)) {
                    return ws.getElements();
                }
                ++n2;
            }
        }
        return this.workingSet.getElements();
    }

    private IAdaptable[] getElementsFromWorkingSet() {
        return this.workingSet.getElements();
    }
}

