/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.editors;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;

public class ZipEntryEditorInput
implements IStorageEditorInput {
    private ZipEntryStorage storage;

    public ZipEntryEditorInput(ZipEntryStorage storage) {
        this.storage = storage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipEntryEditorInput)) {
            return false;
        }
        ZipEntryEditorInput other = (ZipEntryEditorInput)obj;
        return this.storage.equals((Object)other.storage);
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getToolTipText() {
        return this.storage.getFullPath().toString();
    }

    public ImageDescriptor getImageDescriptor() {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        return registry.getImageDescriptor(this.storage.getFullPath().getFileExtension());
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return this.storage.getAdapter(adapter);
    }

    public IStorage getStorage() {
        return this.storage;
    }
}

