/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.ui.AbstractCompositeImageDescriptor;
import org.springframework.ide.eclipse.ui.SpringUIImageFlags;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class SpringUIImages
implements SpringUIImageFlags {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.ui.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_OBJS_PROJECT = "org.springframework.ide.eclipse.ui.project_obj.gif";
    public static final String IMG_OBJS_SPRING = "org.springframework.ide.eclipse.ui.spring_obj.gif";
    public static final String IMG_OBJS_ERROR = "org.springframework.ide.eclipse.ui.error_obj.gif";
    public static final String IMG_OBJS_RULE = "org.springframework.ide.eclipse.ui.rule_obj.gif";
    public static final String IMG_WIZ_WORKINGSET = "org.springframework.ide.eclipse.ui.workingset_wiz.png";
    private static final String OBJECT = "obj16/";
    private static final String OVR = "ovr16/";
    private static final String WIZBAN = "wizban/";
    public static final ImageDescriptor DESC_OBJS_PROJECT;
    public static final ImageDescriptor DESC_OBJS_SPRING;
    public static final ImageDescriptor DESC_OBJS_ERROR;
    public static final ImageDescriptor DESC_OBJS_RULE;
    public static final ImageDescriptor DESC_OVR_SPRING;
    public static final ImageDescriptor DESC_OVR_ERROR;
    public static final ImageDescriptor DESC_OVR_WARNING;
    public static final ImageDescriptor DESC_WIZ_WORKINGSET;

    static {
        try {
            ICON_BASE_URL = new URL(SpringUIPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            SpringUIPlugin.log(e);
        }
        DESC_OBJS_PROJECT = SpringUIImages.createManaged(OBJECT, IMG_OBJS_PROJECT);
        DESC_OBJS_SPRING = SpringUIImages.createManaged(OBJECT, IMG_OBJS_SPRING);
        DESC_OBJS_ERROR = SpringUIImages.createManaged(OBJECT, IMG_OBJS_ERROR);
        DESC_OBJS_RULE = SpringUIImages.createManaged(OBJECT, IMG_OBJS_RULE);
        DESC_OVR_SPRING = SpringUIImages.create(OVR, "spring_ovr.gif");
        DESC_OVR_ERROR = SpringUIImages.create(OVR, "error_ovr.gif");
        DESC_OVR_WARNING = SpringUIImages.create(OVR, "warning_ovr.gif");
        DESC_WIZ_WORKINGSET = SpringUIImages.createManaged(WIZBAN, IMG_WIZ_WORKINGSET);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return SpringUIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static Image getDecoratedImage(String baseImageKey, int flags) {
        return SpringUIImages.getDecoratedImage(SpringUIImages.getImage(baseImageKey), flags);
    }

    public static Image getDecoratedImage(Image baseImage, int flags) {
        SpringUICompositeImageDescriptor descriptor = new SpringUICompositeImageDescriptor(baseImage, flags);
        return SpringUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        SpringUIImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        SpringUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        action.setImageDescriptor(SpringUIImages.create("e" + type, relPath));
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)SpringUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            SpringUIPlugin.log(e);
        }
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)SpringUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            SpringUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)SpringUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            SpringUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }

    private static class SpringUICompositeImageDescriptor
    extends AbstractCompositeImageDescriptor {
        public SpringUICompositeImageDescriptor(Image baseImage, int flags) {
            super(baseImage, flags);
        }

        @Override
        protected void drawOverlays() {
        }
    }
}

