/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.LocationInformation;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class QualifierArgumentProposalComputer
extends AnnotationProposalComputer {
    @Override
    protected List<ICompletionProposal> computeCompletionProposals(SourceMethod method, String value, IAnnotation a, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ITextViewer viewer = javaContext.getViewer();
        if (viewer instanceof SourceViewer) {
            int invocationOffset;
            SourceViewer sourceViewer;
            ICompilationUnit cu = javaContext.getCompilationUnit();
            AssistContext assistContext = new AssistContext(cu, (ISourceViewer)(sourceViewer = (SourceViewer)javaContext.getViewer()), invocationOffset = javaContext.getInvocationOffset(), 0);
            ASTNode node = ((SourceRefElement)a).findNode(assistContext.getASTRoot());
            if (node == null) {
                node = assistContext.getCoveredNode();
            }
            if (!(a instanceof Annotation)) {
                return Collections.emptyList();
            }
            Annotation annotation = (Annotation)a;
            LocationInformation locationInfo = null;
            if (node instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)node;
                List pairs = normalAnnotation.values();
                for (MemberValuePair pair : pairs) {
                    Expression expression = pair.getValue();
                    if (!(expression instanceof StringLiteral)) continue;
                    locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
                }
            } else if (node instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)node;
                Expression expression = singleMemberAnnotation.getValue();
                locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
            }
            if (locationInfo == null) {
                return Collections.emptyList();
            }
            ISourceRange methodSourceRange = method.getSourceRange();
            assistContext = new AssistContext(javaContext.getCompilationUnit(), (ISourceViewer)sourceViewer, methodSourceRange.getOffset(), methodSourceRange.getLength());
            node = assistContext.getCoveringNode();
            if (node instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)node;
                List parameters = methodDecl.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("Qualifier", invocationOffset, (ASTNode)parameter);
                    for (Annotation an : annotations) {
                        if (!an.equals((Object)annotation)) continue;
                        ITypeBinding typeBinding = parameter.getType().resolveBinding();
                        proposals.addAll(this.getMatchingBeansProposal(locationInfo.getFilter(), typeBinding, (BodyDeclaration)methodDecl, javaContext, locationInfo));
                    }
                }
            }
        }
        return proposals;
    }

    @Override
    protected List<ICompletionProposal> computeCompletionProposals(SourceField field, String value, IAnnotation a, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ITextViewer viewer = javaContext.getViewer();
        if (viewer instanceof SourceViewer) {
            int invocationOffset;
            SourceViewer sourceViewer;
            ICompilationUnit cu = javaContext.getCompilationUnit();
            AssistContext assistContext = new AssistContext(cu, (ISourceViewer)(sourceViewer = (SourceViewer)javaContext.getViewer()), invocationOffset = javaContext.getInvocationOffset(), 0);
            ASTNode node = ((SourceRefElement)a).findNode(assistContext.getASTRoot());
            if (node == null) {
                node = assistContext.getCoveredNode();
            }
            LocationInformation locationInfo = null;
            if (node instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)node;
                List pairs = normalAnnotation.values();
                for (MemberValuePair pair : pairs) {
                    Expression expression = pair.getValue();
                    if (!(expression instanceof StringLiteral)) continue;
                    locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
                }
            } else if (node instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)node;
                Expression expression = singleMemberAnnotation.getValue();
                locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
            }
            if (locationInfo == null) {
                return Collections.emptyList();
            }
            ISourceRange fieldSourceRange = field.getSourceRange();
            assistContext = new AssistContext(javaContext.getCompilationUnit(), (ISourceViewer)sourceViewer, fieldSourceRange.getOffset(), fieldSourceRange.getLength());
            node = assistContext.getCoveringNode();
            if (node instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)node;
                ITypeBinding typeBinding = fieldDecl.getType().resolveBinding();
                proposals.addAll(this.getMatchingBeansProposal(locationInfo.getFilter(), typeBinding, (BodyDeclaration)fieldDecl, javaContext, locationInfo));
            }
        }
        return proposals;
    }

    private List<JavaCompletionProposal> getMatchingBeansProposal(String filter, ITypeBinding typeBinding, BodyDeclaration decl, JavaContentAssistInvocationContext javaContext, LocationInformation info) {
        int locationOffset = info.getOffset();
        int locationLength = info.getLength();
        boolean isQuoted = info.isQuoted();
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        if (typeBinding != null) {
            Set<String> matchingBeans = ProposalCalculatorUtil.getMatchingBeans(javaContext, typeBinding);
            for (String matchingBean : matchingBeans) {
                if (!matchingBean.startsWith(filter)) continue;
                if (isQuoted) {
                    proposals.add(new JavaCompletionProposal(matchingBean, locationOffset, locationLength, BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif"), matchingBean, 0));
                    continue;
                }
                proposals.add(new JavaCompletionProposal("\"" + matchingBean + "\"", locationOffset, locationLength, BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif"), matchingBean, 0));
            }
        }
        return proposals;
    }
}

