/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.boot.properties.editor.completions.DocumentEdits;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.IndentUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlDocument;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPath;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.structure.YamlStructureParser;

public class YamlPathEdits
extends DocumentEdits {
    private YamlDocument doc;
    private IndentUtil indentUtil;

    public YamlPathEdits(YamlDocument doc) {
        super(doc.getDocument());
        this.doc = doc;
        this.indentUtil = new IndentUtil(doc);
    }

    public void createPath(YamlStructureParser.SChildBearingNode node, YamlPath path, String appendText) throws Exception {
        Assert.isLegal((node.getNodeType() != YamlStructureParser.SNodeType.ROOT ? 1 : 0) != 0);
        if (!path.isEmpty()) {
            YamlPathSegment s = path.getSegment(0);
            if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
                String key = s.toPropString();
                YamlStructureParser.SKeyNode existing = this.findChildForKey(node, key);
                if (existing == null) {
                    this.createNewPath(node, path, appendText);
                } else {
                    this.createPath(existing, path.tail(), appendText);
                }
            }
        } else {
            YamlStructureParser.SNode child = node.getFirstRealChild();
            if (child != null) {
                this.moveCursorTo(child.getStart());
            } else if (node.getNodeType() == YamlStructureParser.SNodeType.KEY) {
                YamlStructureParser.SKeyNode keyNode = (YamlStructureParser.SKeyNode)node;
                int colonOffset = keyNode.getColonOffset();
                char c = this.doc.getChar(colonOffset + 1);
                if (c == ' ') {
                    this.moveCursorTo(colonOffset + 2);
                } else {
                    this.moveCursorTo(colonOffset + 1);
                }
            }
        }
    }

    private void createNewPath(YamlStructureParser.SChildBearingNode parent, YamlPath path, String appendText) throws Exception {
        int indent = this.getChildIndent(parent);
        int insertionPoint = this.getNewPathInsertionOffset(parent);
        boolean startOnNewLine = true;
        this.insert(insertionPoint, this.createPathInsertionText(path, indent, startOnNewLine, appendText));
    }

    protected String createPathInsertionText(YamlPath path, int indent, boolean startOnNewLine, String appendText) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < path.size()) {
            if (startOnNewLine || i > 0) {
                this.indentUtil.addNewlineWithIndent(indent, buf);
            }
            String key = path.getSegment(i).toPropString();
            buf.append(key);
            buf.append(":");
            indent += 2;
            ++i;
        }
        buf.append(this.indentUtil.applyIndentation(appendText, indent));
        return buf.toString();
    }

    private int getChildIndent(YamlStructureParser.SNode parent) {
        if (parent.getNodeType() == YamlStructureParser.SNodeType.DOC) {
            return parent.getIndent();
        }
        return parent.getIndent() + 2;
    }

    private int getNewPathInsertionOffset(YamlStructureParser.SChildBearingNode parent) throws Exception {
        int insertAfterLine = this.doc.getLineOfOffset(parent.getTreeEnd());
        while (insertAfterLine >= 0 && this.doc.getLineIndentation(insertAfterLine) == -1) {
            --insertAfterLine;
        }
        if (insertAfterLine < 0) {
            return 0;
        }
        IRegion r = this.doc.getLineInformation(insertAfterLine);
        return r.getOffset() + r.getLength();
    }

    private YamlStructureParser.SKeyNode findChildForKey(YamlStructureParser.SChildBearingNode node, String key) throws Exception {
        for (YamlStructureParser.SNode c : node.getChildren()) {
            String nodeKey;
            if (c.getNodeType() != YamlStructureParser.SNodeType.KEY || !key.equals(nodeKey = ((YamlStructureParser.SKeyNode)c).getKey())) continue;
            return (YamlStructureParser.SKeyNode)c;
        }
        return null;
    }

    public void createPathInPlace(YamlStructureParser.SNode contextNode, YamlPath relativePath, int insertionPoint, String appendText) throws Exception {
        int indent = this.getChildIndent(contextNode);
        this.insert(insertionPoint, this.createPathInsertionText(relativePath, indent, this.needNewline(contextNode, insertionPoint), appendText));
    }

    private boolean needNewline(YamlStructureParser.SNode contextNode, int insertionPoint) throws Exception {
        if (contextNode.getNodeType() == YamlStructureParser.SNodeType.SEQ) {
            return false;
        }
        return this.lineHasTextBefore(insertionPoint);
    }

    private boolean lineHasTextBefore(int insertionPoint) throws Exception {
        String textBefore = this.doc.getLineTextBefore(insertionPoint);
        return !textBefore.trim().isEmpty();
    }
}

