/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.Collector;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.IRequestor;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.NodeRef;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.RememberLast;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YamlFileAST {
    private static final List<NodeRef<?>> NO_CHILDREN = Collections.emptyList();
    private List<Node> nodes = new ArrayList<Node>();

    public YamlFileAST(Iterable<Node> iter) {
        for (Node node : iter) {
            this.nodes.add(node);
        }
    }

    public List<NodeRef<?>> findPath(int offset) {
        Collector path = new Collector();
        this.findPath(offset, path);
        return path.get();
    }

    public void findPath(int offset, IRequestor<NodeRef<?>> pathRequestor) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = this.nodes.get(i);
            if (NodeUtil.contains(node, offset)) {
                pathRequestor.accept(new NodeRef.RootRef(this, i));
                this.findPath(node, offset, pathRequestor);
                return;
            }
            ++i;
        }
    }

    private void findPath(Node n, int offset, IRequestor<NodeRef<?>> pathRequestor) {
        List<NodeRef<?>> children = YamlFileAST.getChildren(n);
        int i = 0;
        while (i < children.size()) {
            NodeRef<?> c = children.get(i);
            if (NodeUtil.contains(c.get(), offset)) {
                pathRequestor.accept(c);
                this.findPath(c.get(), offset, pathRequestor);
                return;
            }
            ++i;
        }
    }

    public static List<NodeRef<?>> getChildren(Node n) {
        switch (n.getNodeId()) {
            case scalar: {
                return NO_CHILDREN;
            }
            case sequence: {
                return YamlFileAST.getChildren((SequenceNode)n);
            }
            case mapping: {
                return YamlFileAST.getChildren((MappingNode)n);
            }
            case anchor: {
                return NO_CHILDREN;
            }
        }
        return null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    private static List<NodeRef<?>> getChildren(SequenceNode seq) {
        int nodes = seq.getValue().size();
        ArrayList children = new ArrayList(nodes);
        int i = 0;
        while (i < nodes) {
            children.add(new NodeRef.SeqRef(seq, i));
            ++i;
        }
        return children;
    }

    private static List<NodeRef<?>> getChildren(MappingNode map) {
        int entries = map.getValue().size();
        ArrayList children = new ArrayList(entries * 2);
        int i = 0;
        while (i < entries) {
            children.add(new NodeRef.TupleKeyRef(map, i));
            children.add(new NodeRef.TupleValueRef(map, i));
            ++i;
        }
        return children;
    }

    public NodeRef<?> findNodeRef(int offset) {
        RememberLast lastNode = new RememberLast();
        this.findPath(offset, lastNode);
        return lastNode.get();
    }

    public Node findNode(int offset) {
        NodeRef<?> ref = this.findNodeRef(offset);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public Node get(int index) {
        return this.nodes.get(index);
    }

    public void put(int index, Node value) {
        this.nodes.set(index, value);
    }
}

