/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.springsource.ide.eclipse.commons.frameworks.ui.FrameworkUIActivator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelectionHandler;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelector;

public class ProjectSelectionPart
extends ProjectSelector {
    private Combo projectList;
    private Collection<IProject> projects;
    private boolean showProjectSwitchDialogue;
    private IProjectSelectionHandler handler;
    public static final String DO_NOT_PROMPT_PROJECT_SWITCH = "DoNotPromptProjectSwitch";

    public ProjectSelectionPart(Shell shell, Composite parent, Collection<IProject> projects, IProjectSelectionHandler handler) {
        super(shell, parent);
        this.projects = projects;
        this.handler = handler;
    }

    public void showProjectSwitchDialogue(boolean show) {
        this.showProjectSwitchDialogue = show;
    }

    protected Collection<IProject> getProjects() {
        return this.projects;
    }

    @Override
    public Composite createProjectArea() {
        Collection<IProject> availableProjects = this.getProjects();
        if (availableProjects == null || availableProjects.isEmpty()) {
            return null;
        }
        Composite parent = super.createProjectArea();
        String[] availableProjectNames = new String[availableProjects.size()];
        int i = 0;
        for (IProject project : availableProjects) {
            if (i >= availableProjectNames.length) continue;
            availableProjectNames[i++] = project.getName();
        }
        this.projectList = new Combo(parent, 12);
        this.projectList.setItems(availableProjectNames);
        this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                if (widget == ProjectSelectionPart.this.projectList) {
                    String newSelection = ProjectSelectionPart.this.projectList.getItem(ProjectSelectionPart.this.projectList.getSelectionIndex());
                    ProjectSelectionPart.this.changeProject(newSelection);
                }
            }
        });
        this.projectList.select(0);
        this.setSelectedProjectName(availableProjectNames[0]);
        return parent;
    }

    protected IProject changeProject(String projectNameToSwitch) {
        MessageDialogWithToggle dialogue;
        if (projectNameToSwitch == null) {
            return null;
        }
        int selectedIndex = -1;
        String[] availableProjects = this.projectList.getItems();
        int i = 0;
        while (i < availableProjects.length) {
            if (projectNameToSwitch.equals(availableProjects[i])) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedIndex < 0) {
            return null;
        }
        if (this.showProjectSwitchDialogue && !"always".equals(FrameworkUIActivator.getDefault().getPreferenceStore().getString(DO_NOT_PROMPT_PROJECT_SWITCH)) && (dialogue = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)this.getShell(), (String)"Confirm Project Switch", (String)("Switching to project: " + projectNameToSwitch + ". All current plugin changes will be lost. Do you wish to proceed?"), (String)"Do not show this dialogue again.", (boolean)false, (IPreferenceStore)FrameworkUIActivator.getDefault().getPreferenceStore(), (String)DO_NOT_PROMPT_PROJECT_SWITCH)).getReturnCode() != 2) {
            this.projectList.select(this.getIndex(this.getSelectedProjectName()));
            return null;
        }
        this.setSelectedProjectName(projectNameToSwitch);
        this.projectList.select(selectedIndex);
        IProject project = this.getSelectedProject();
        this.handleProjectChange(project);
        return project;
    }

    protected int getIndex(String name) {
        if (this.projectList == null || name == null) {
            return -1;
        }
        String[] items = this.projectList.getItems();
        if (items == null) {
            return -1;
        }
        int i = 0;
        while (i < items.length) {
            if (name.equals(items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean selectProject(IProject project) {
        if (this.projectList == null || this.projectList.isDisposed() || project == null) {
            return false;
        }
        String currentSelection = this.getSelectedProjectName();
        String projectNameToSwitch = project.getName();
        if (currentSelection == null || currentSelection.equals(projectNameToSwitch)) {
            return false;
        }
        return this.changeProject(projectNameToSwitch) != null;
    }

    @Override
    public boolean setProject(IProject project) {
        boolean result = this.selectProject(project);
        if (result) {
            super.setProject(project);
        }
        return result;
    }

    protected void handleProjectChange(IProject selectedProject) {
        if (this.handler != null) {
            this.handler.handleProjectSelectionChange(selectedProject);
        }
    }
}

