/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.w3c.dom.Node;

public class WebflowBeanReferenceHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IWebflowConfig config;
        IFile file = BeansEditorUtils.getFile((IDocument)document);
        if (file != null && file.exists() && (config = Activator.getModel().getProject(file.getProject()).getConfig(file)) != null) {
            Set beans = WebflowModelUtils.getBeans((IWebflowConfig)config);
            for (IBean bean : beans) {
                if (!bean.getElementName().equals(target)) continue;
                return new ExternalBeanHyperlink((ISourceModelElement)bean, hyperlinkRegion);
            }
        }
        return null;
    }
}

