/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.wizard.template.ITemplateWizardPage;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;

public class WizardTextKeyValidator
extends KeyAdapter {
    private final int index;
    private final WizardUIInfoElement element;
    private final Text text;
    private final ITemplateWizardPage page;

    public WizardTextKeyValidator(int index, WizardUIInfoElement element, Text text, ITemplateWizardPage page) {
        this.index = index;
        this.element = element;
        this.text = text;
        this.page = page;
    }

    public void keyReleased(KeyEvent e) {
        this.validate();
        this.page.updateMessage();
    }

    public void validate() {
        String[] errorMessages = this.page.getErrorMessages();
        String[] messages = this.page.getMessages();
        errorMessages[this.index] = null;
        messages[this.index] = null;
        String textEntered = this.text.getText();
        String errorMsg = this.element.getErrorMessage();
        if (textEntered == null || textEntered.length() == 0) {
            if (this.element.getRequired()) {
                messages[this.index] = errorMsg != null && errorMsg.length() > 0 ? errorMsg : "Enter a  " + this.element.getName() + ".";
            }
        } else {
            String regex = this.element.getPattern();
            if (regex != null && !Pattern.matches(regex, textEntered)) {
                errorMessages[this.index] = errorMsg != null && errorMsg.length() > 0 ? errorMsg : "Input for field " + this.element.getName() + " does not match the regex " + regex + ".";
            }
        }
    }
}

