/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class ErrorUtils {
    private static int WIZARD_ERROR_MAX_CHAR_LENGTH = 50;

    private ErrorUtils() {
    }

    public static boolean isWithinWizardErrorMaximum(String errorMessage) {
        return errorMessage.length() <= WIZARD_ERROR_MAX_CHAR_LENGTH;
    }

    public static String getErrorMessage(String errorMessagePrefix, Exception e) {
        String fullError = null;
        String exceptionError = null;
        if (e instanceof InvocationTargetException) {
            exceptionError = ErrorUtils.getErrorMessage((InvocationTargetException)e);
        } else if (e instanceof CoreException) {
            exceptionError = ErrorUtils.getErrorMessage((CoreException)((Object)e));
        } else if (e != null) {
            exceptionError = e.getMessage();
        }
        if (exceptionError != null && (exceptionError = exceptionError.trim()).length() > 0) {
            fullError = errorMessagePrefix != null ? String.valueOf(errorMessagePrefix) + ". Cause: " + exceptionError : exceptionError;
        }
        if (fullError == null) {
            fullError = errorMessagePrefix;
        }
        return fullError;
    }

    public static String getErrorMessage(CoreException e) {
        if (e == null) {
            return null;
        }
        return ErrorUtils.getErrorMessage(e.getStatus());
    }

    public static String getErrorMessage(InvocationTargetException e) {
        if (e.getTargetException() != null) {
            if (e.getTargetException() instanceof CoreException) {
                return ErrorUtils.getErrorMessage((CoreException)e.getTargetException());
            }
            return e.getTargetException().getMessage();
        }
        return e.getMessage();
    }

    public static String getErrorMessage(IStatus status) {
        String error = null;
        if (status instanceof MultiStatus) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            if (children != null) {
                IStatus[] iStatusArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    error = ErrorUtils.getErrorMessage(child);
                    if (error == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else if (status.getSeverity() == 4) {
            error = status.getMessage();
        }
        return error;
    }
}

