/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.runtime.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.progress.IProgressConstants;
import org.springframework.ide.eclipse.osgi.runtime.OsgiUiImages;
import org.springframework.ide.eclipse.osgi.runtime.builder.OsgiBundleUpdateBuilder;

class OsgiUpdateJob
extends Job {
    private static final String YES_COMMAND = "y";
    private static final String DISCONNECT_COMMAND = "disconnect";
    public static final Object MODEL_CONTENT_FAMILY = new Object();
    private String symbolicName;
    private OsgiBundleUpdateBuilder.Command command;

    private OsgiUpdateJob(String symbolicName, OsgiBundleUpdateBuilder.Command command) {
        super("Refreshing bundle with symbolic name '" + symbolicName + "'");
        this.symbolicName = symbolicName;
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        block23: {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(MODEL_CONTENT_FAMILY);
                int i = 0;
                while (i < buildJobs.length) {
                    OsgiUpdateJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof OsgiUpdateJob && (job = (OsgiUpdateJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            int port = this.getPort();
            monitor.beginTask("Connecting to OSGi runtime running at port " + port, 1);
            BufferedReader in = null;
            PrintWriter out = null;
            try {
                try {
                    Socket socket = new Socket(InetAddress.getLocalHost(), port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    this.emitCommnad(out, String.valueOf(this.command.toString().toLowerCase()) + " " + this.symbolicName);
                    this.emitCommnad(out, DISCONNECT_COMMAND);
                    this.emitCommnad(out, YES_COMMAND);
                }
                catch (Exception exception) {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Status.OK_STATUS;
    }

    private void emitCommnad(PrintWriter writer, String command) throws Exception {
        writer.println(command);
        writer.flush();
        Thread.sleep(500L);
    }

    private int getPort() {
        InstanceScope context = new InstanceScope();
        IEclipsePreferences preferences = context.getNode("org.springframework.ide.eclipse.osgi.runtime");
        return Integer.valueOf(preferences.get("console.port", "2000"));
    }

    public boolean isCoveredBy(OsgiUpdateJob other) {
        return other.symbolicName.equals(this.symbolicName) && other.command.equals((Object)this.command);
    }

    public boolean belongsTo(Object family) {
        return MODEL_CONTENT_FAMILY == family;
    }

    public static void schedule(String symbolicName, OsgiBundleUpdateBuilder.Command command) {
        OsgiUpdateJob job = new OsgiUpdateJob(symbolicName, command);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setPriority(40);
        job.setProperty(IProgressConstants.ICON_PROPERTY, OsgiUiImages.DESC_OBJS_OSGI);
        job.schedule();
    }
}

