/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;

public class WebflowModelNavigatorSorter
extends ViewerSorter {
    public int category(Object element) {
        if (element instanceof IWebflowConfig) {
            return 2;
        }
        return 0;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (SpringUIUtils.isSortingEnabled() && SpringUIUtils.isSpringExplorer((Viewer)viewer)) {
            if (e1 instanceof IWebflowConfig && e2 instanceof IWebflowConfig) {
                String f1 = this.getFileLabel(((IWebflowConfig)e1).getResource());
                String f2 = this.getFileLabel(((IWebflowConfig)e2).getResource());
                return super.compare(viewer, (Object)f1, (Object)f2);
            }
            return super.compare(viewer, e1, e2);
        }
        return 0;
    }

    private String getFileLabel(IFile file) {
        return String.valueOf(file.getName()) + " - " + file.getProjectRelativePath().removeLastSegments(1).toString();
    }
}

