/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.savefilter;

import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.savefilter.ISaveFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class SaveFilters {
    private static final String FILTER_EXTENSION_POINT = "net.sf.eclipsecs.core.saveFilters";
    private static final String ATTR_CLASS = "class";
    private static final ISaveFilter[] SAVE_FILTERS;

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(FILTER_EXTENSION_POINT);
        ArrayList<ISaveFilter> filters = new ArrayList<ISaveFilter>();
        int i = 0;
        while (i < elements.length) {
            try {
                ISaveFilter filter = (ISaveFilter)elements[i].createExecutableExtension(ATTR_CLASS);
                filters.add(filter);
            }
            catch (Exception e) {
                CheckstyleLog.log(e);
            }
            ++i;
        }
        SAVE_FILTERS = filters.toArray(new ISaveFilter[filters.size()]);
    }

    private SaveFilters() {
    }

    public static void process(List<Module> configuredModules) {
        int i = 0;
        while (i < SAVE_FILTERS.length) {
            SAVE_FILTERS[i].postProcessConfiguredModules(configuredModules);
            ++i;
        }
    }
}

