/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.AjdtUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.ProjectClassLoaderCache;
import org.springframework.ide.eclipse.core.java.SuperTypeHierarchyCache;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class JdtUtils {
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String GROOVY_FILE_EXTENSION = ".groovy";
    public static final String JAVA_FILE_EXTENSION = ".java";
    private static final String AJDT_CLASS = "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager";
    private static final String AJDT_NATURE = "org.eclipse.ajdt.ui.ajnature";
    private static final String CLASSPATH_FILENAME = ".classpath";
    private static final boolean IS_AJDT_PRESENT = JdtUtils.isAjdtPresent();

    public static IJavaProject createJavaProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject project = SpringCoreUtils.createProject((String)projectName, null, (IProgressMonitor)monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            SpringCoreUtils.addProjectNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        }
        IJavaProject jproject = JavaCore.create((IProject)project);
        jproject.setRawClasspath(new IClasspathEntry[]{JdtUtils.getJreVariableEntry()}, monitor);
        jproject.setOutputLocation(project.getFullPath(), monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return jproject;
    }

    public static boolean doesImplement(IResource resource, IType type, String className) {
        return JdtUtils.doesImplement(resource, type, className, SpringCore.getTypeHierarchyEngine());
    }

    public static boolean doesImplement(IResource resource, IType type, String className, TypeHierarchyEngine typeEngine) {
        if (resource == null || type == null || className == null) {
            return false;
        }
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            try {
                ClassLoader cls = JdtUtils.getClassLoader(resource.getProject(), null);
                Class<?> typeClass = cls.loadClass(type.getFullyQualifiedName('$'));
                Class<?> interfaceClass = cls.loadClass(className);
                return typeClass.equals(interfaceClass) || interfaceClass.isAssignableFrom(typeClass);
            }
            catch (Throwable throwable) {}
        }
        if (System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true")) {
            return typeEngine.doesImplement(type, className) || typeEngine.doesExtend(type, className);
        }
        return JdtUtils.doesImplementWithJdt(resource, type, className);
    }

    public static IType getAjdtType(IProject project, String className) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (IS_AJDT_PRESENT && javaProject != null && className != null) {
            try {
                IType type = null;
                if (JdtUtils.isAjdtProject((IResource)project) && (type = AjdtUtils.getAjdtType(project, className)) != null) {
                    return type;
                }
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    if (JdtUtils.isAjdtProject((IResource)refProject) && (type = AjdtUtils.getAjdtType(refProject, className)) != null) {
                        return type;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                SpringCore.log("Error getting Java type '" + className + "'", e);
            }
        }
        return null;
    }

    public static List<IJavaProject> getAllDependingJavaProjects(IJavaProject project) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        if (model != null) {
            try {
                String[] names = project.getRequiredProjectNames();
                IJavaProject[] projects = model.getJavaProjects();
                int index = 0;
                while (index < projects.length) {
                    int offset = 0;
                    while (offset < names.length) {
                        String name = projects[index].getProject().getName();
                        if (name.equals(names[offset])) {
                            javaProjects.add(projects[index]);
                        }
                        ++offset;
                    }
                    ++index;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return javaProjects;
    }

    public static Set<URL> getBundleClassPath(String bundleId) {
        HashSet<URL> paths;
        block9: {
            paths = new HashSet<URL>();
            try {
                Bundle bundle = Platform.getBundle((String)bundleId);
                if (bundle == null) break block9;
                String bundleClassPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
                if (bundleClassPath != null) {
                    String[] classPathEntries;
                    String[] stringArray = classPathEntries = StringUtils.delimitedListToStringArray((String)bundleClassPath, (String)",");
                    int n = classPathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String classPathEntry = stringArray[n2];
                        if (".".equals(classPathEntry.trim())) {
                            paths.add(FileLocator.toFileURL((URL)bundle.getEntry("/")));
                        } else {
                            try {
                                paths.add(FileLocator.toFileURL((URL)new URL(bundle.getEntry("/"), "/" + classPathEntry.trim())));
                            }
                            catch (FileNotFoundException e) {
                                SpringCore.log("bundle classpath entry \"" + classPathEntry.trim() + "\" of bundle " + bundle.getSymbolicName() + " not found and therefore ignored", e);
                            }
                        }
                        ++n2;
                    }
                    break block9;
                }
                paths.add(FileLocator.toFileURL((URL)bundle.getEntry("/")));
            }
            catch (MalformedURLException e) {
                SpringCore.log(e);
            }
            catch (IOException e) {
                SpringCore.log(e);
            }
        }
        return paths;
    }

    public static IJavaElement getByHandle(String handle) {
        if (IS_AJDT_PRESENT) {
            return AjdtUtils.getByHandle(handle);
        }
        return JavaCore.create((String)handle);
    }

    public static ClassLoader getClassLoader(IProject project, ClassLoader parentClassLoader) {
        return ProjectClassLoaderCache.getClassLoader(project, parentClassLoader);
    }

    public static void removeClassLoaderEntryFromCache(IProject project) {
        ProjectClassLoaderCache.removeClassLoaderEntryFromCache(project);
    }

    public static IMethod getConstructor(IType type, Class[] parameterTypes) {
        String[] parameterTypesAsString = JdtUtils.getParameterTypesAsStringArray(parameterTypes);
        return JdtUtils.getConstructor(type, parameterTypesAsString);
    }

    public static IMethod getConstructor(IType type, String[] parameterTypes) {
        try {
            Set<IMethod> methods = Introspector.getAllConstructors(type);
            for (IMethod method : methods) {
                Object[] methodParameterTypes;
                if (method.getParameterTypes().length != parameterTypes.length || !Arrays.deepEquals(parameterTypes, methodParameterTypes = JdtUtils.getParameterTypesAsStringArray(method))) continue;
                return method;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IField getField(IType type, String fieldName) {
        return JdtUtils.getField(type, fieldName, true);
    }

    public static IField getField(IType type, String fieldName, boolean includeHierarchy) {
        try {
            while (type != null) {
                IField[] iFieldArray = type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (field.getElementName().equals(fieldName)) {
                        return field;
                    }
                    ++n2;
                }
                if (includeHierarchy) {
                    type = Introspector.getSuperType(type);
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static List<String> getFlatListOfClassAndInterfaceNames(IType parameterType, IType type) {
        ArrayList<String> requiredTypes = new ArrayList<String>();
        if (parameterType != null) {
            do {
                try {
                    String[] interfaceNames;
                    requiredTypes.add(parameterType.getFullyQualifiedName());
                    String[] stringArray = interfaceNames = parameterType.getSuperInterfaceNames();
                    int n = interfaceNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String interfaceName = stringArray[n2];
                        if (interfaceName != null) {
                            String resolvedName;
                            if (type.isBinary()) {
                                requiredTypes.add(interfaceName);
                            }
                            if ((resolvedName = JdtUtils.resolveClassName(interfaceName, type)) != null) {
                                requiredTypes.add(resolvedName);
                            }
                        }
                        ++n2;
                    }
                    parameterType = Introspector.getSuperType(parameterType);
                }
                catch (JavaModelException javaModelException) {}
            } while (parameterType != null && !parameterType.getFullyQualifiedName().equals(Object.class.getName()));
        }
        return requiredTypes;
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                SpringCore.log("Error getting Java project for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static IJavaProject getJavaProject(IResource config) {
        IJavaProject project = JavaCore.create((IProject)config.getProject());
        return project;
    }

    public static IType getJavaType(IProject project, String className) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (className != null) {
            String unchangedClassName = null;
            int pos = className.lastIndexOf(36);
            if (pos > 0) {
                unchangedClassName = className;
                className = className.replace('$', '.');
            }
            try {
                IType type = null;
                if (javaProject != null) {
                    type = javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor());
                    if (type == null && unchangedClassName != null) {
                        type = JdtUtils.findTypeWithInnerClassesInvolved(javaProject, unchangedClassName, new NullProgressMonitor());
                    }
                    if (type != null) {
                        return type;
                    }
                }
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    IJavaProject refJavaProject = JdtUtils.getJavaProject(refProject);
                    if (refJavaProject != null) {
                        type = refJavaProject.findType(className);
                        if (type == null && unchangedClassName != null) {
                            type = JdtUtils.findTypeWithInnerClassesInvolved(javaProject, unchangedClassName, new NullProgressMonitor());
                        }
                        if (type != null) {
                            return type;
                        }
                    }
                    ++n2;
                }
                return JdtUtils.getAjdtType(project, className);
            }
            catch (CoreException e) {
                SpringCore.log("Error getting Java type '" + className + "'", e);
            }
        }
        return null;
    }

    protected static IType findTypeWithInnerClassesInvolved(IJavaProject javaProject, String fullClassName, NullProgressMonitor progressMonitor) throws JavaModelException {
        IType result = javaProject.findType(fullClassName, (IProgressMonitor)progressMonitor);
        return result;
    }

    public static final IType getJavaTypeForMethodReturnType(IMethod method, IType contextType) {
        try {
            return JdtUtils.getJavaTypeFromSignatureClassName(method.getReturnType(), contextType);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IType getJavaTypeFromSignatureClassName(String className, IType contextType) {
        if (contextType == null || className == null) {
            return null;
        }
        try {
            return JdtUtils.getJavaType(contextType.getJavaProject().getProject(), JdtUtils.resolveClassNameBySignature(className, contextType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static final List<IType> getJavaTypesForMethodParameterTypes(IMethod method, IType contextType) {
        String[] parameterTypeNames;
        if (method == null || method.getParameterTypes() == null || method.getParameterTypes().length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IType> parameterTypes = new ArrayList<IType>(method.getParameterTypes().length);
        String[] stringArray = parameterTypeNames = method.getParameterTypes();
        int n = parameterTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterTypeName = stringArray[n2];
            parameterTypes.add(JdtUtils.getJavaTypeFromSignatureClassName(parameterTypeName, contextType));
            ++n2;
        }
        return parameterTypes;
    }

    public static IClasspathEntry getJreVariableEntry() {
        return JavaRuntime.getDefaultJREContainerEntry();
    }

    public static int getLineNumber(IJavaElement element) {
        if (element != null && element instanceof IMethod) {
            try {
                String targetsource;
                IMethod method = (IMethod)element;
                int lines = 0;
                if (method.getDeclaringType() != null && method.getDeclaringType().getCompilationUnit() != null && (targetsource = method.getDeclaringType().getCompilationUnit().getSource()) != null) {
                    String sourceuptomethod = targetsource.substring(0, method.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char element0 = cArray[n2];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n2;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element != null && element instanceof IType && ((IType)element).getCompilationUnit() != null) {
            try {
                IType type = (IType)element;
                int lines = 0;
                String targetsource = type.getCompilationUnit().getSource();
                if (targetsource != null) {
                    String sourceuptomethod = targetsource.substring(0, type.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n3 = 0;
                    while (n3 < n) {
                        char element0 = cArray[n3];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n3;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element != null && element instanceof IField) {
            try {
                String targetsource;
                IField type = (IField)element;
                int lines = 0;
                ICompilationUnit cu = type.getCompilationUnit();
                if (cu != null && (targetsource = cu.getSource()) != null) {
                    String sourceuptomethod = targetsource.substring(0, type.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n4 = 0;
                    while (n4 < n) {
                        char element0 = cArray[n4];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n4;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return new Integer(-1);
    }

    public static IMethod getMethod(IType type, String methodName, Class[] parameterTypes) {
        String[] parameterTypesAsString = JdtUtils.getParameterTypesAsStringArray(parameterTypes);
        return JdtUtils.getMethod(type, methodName, parameterTypesAsString);
    }

    public static IMethod getMethod(IType type, String methodName, String[] parameterTypes) {
        return JdtUtils.getMethod(type, methodName, parameterTypes, true);
    }

    public static IMethod getMethod(IType type, String methodName, String[] parameterTypes, boolean includeHierarchy) {
        int index = methodName.indexOf(40);
        if (index >= 0) {
            methodName = methodName.substring(0, index);
        }
        try {
            while (type != null) {
                IMethod[] iMethodArray = Introspector.getMethods(type);
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] methodParameterTypes;
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(methodName) && method.getParameterTypes().length == parameterTypes.length && Arrays.deepEquals(parameterTypes, methodParameterTypes = JdtUtils.getParameterTypesAsStringArray(method))) {
                        return method;
                    }
                    ++n2;
                }
                if (!includeHierarchy) break;
                type = Introspector.getSuperType(type);
            }
            return Introspector.findMethod(type, methodName, parameterTypes.length, Introspector.Public.YES, Introspector.Static.DONT_CARE);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getMethodName(IMethod method) {
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            methodName = methodName.substring(index + 1);
        }
        return methodName;
    }

    public static String[] getParameterTypesString(IMethod method) {
        try {
            String[] parameterQualifiedTypes = Signature.getParameterTypes((String)method.getSignature());
            int length = parameterQualifiedTypes == null ? 0 : parameterQualifiedTypes.length;
            String[] parameterPackages = new String[length];
            int i = 0;
            while (i < length) {
                parameterQualifiedTypes[i] = parameterQualifiedTypes[i].replace('/', '.');
                parameterPackages[i] = Signature.getSignatureSimpleName((String)parameterQualifiedTypes[i]);
                ++i;
            }
            return parameterPackages;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String getParentName(IMethod method) {
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            return methodName.substring(0, index);
        }
        return method.getParent().getElementName();
    }

    public static IProjectClassLoaderSupport getProjectClassLoaderSupport(IProject je, ClassLoader parentClassLoader) {
        return new DefaultProjectClassLoaderSupport(je, parentClassLoader);
    }

    public static String getPropertyNameFromMethodName(IMethod method) {
        String replaceText;
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            methodName = methodName.substring(index + 1);
        }
        if ((replaceText = methodName.substring("set".length())) != null) {
            replaceText = java.beans.Introspector.decapitalize(replaceText);
        }
        return replaceText;
    }

    public static String getReturnTypeString(IMethod method, boolean classTypesOnly) {
        try {
            String qualifiedReturnType = Signature.getReturnType((String)method.getSignature());
            if (!classTypesOnly || qualifiedReturnType.startsWith("L") || qualifiedReturnType.startsWith("Q")) {
                return Signature.getSignatureSimpleName((String)qualifiedReturnType.replace('/', '.'));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IResource getSourceResource(IResource classFile) {
        try {
            if (JdtUtils.isJavaProject(classFile) && classFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                int n;
                IPath classFilePath = classFile.getFullPath();
                String classFileName = null;
                IJavaProject project = JdtUtils.getJavaProject(classFile);
                IPath defaultOutput = project.getOutputLocation();
                if (defaultOutput.isPrefixOf(classFilePath)) {
                    classFileName = classFilePath.removeFirstSegments(defaultOutput.segmentCount()).toString();
                } else {
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath output;
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null && classFilePath.isPrefixOf(output)) {
                            classFileName = classFilePath.removeFirstSegments(output.segmentCount()).toString();
                        }
                        ++n2;
                    }
                }
                if (classFileName != null) {
                    String sourceFileName = classFileName.replace(CLASS_FILE_EXTENSION, JAVA_FILE_EXTENSION);
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    int n3 = iClasspathEntryArray.length;
                    n = 0;
                    while (n < n3) {
                        IClasspathEntry entry = iClasspathEntryArray[n];
                        if (entry.getEntryKind() == 3) {
                            IPath path = entry.getPath().append(sourceFileName).removeFirstSegments(1);
                            IResource resource = project.getProject().findMember(path);
                            if (resource != null) {
                                return resource;
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static boolean isAjdtPresent() {
        return Platform.getBundle((String)"org.eclipse.ajdt.core") != null;
    }

    public static boolean isAjdtProject(IResource resource) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature(AJDT_NATURE);
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return false;
    }

    public static boolean isClassPathFile(IResource resource) {
        String classPathFileName = resource.getProject().getFullPath().append(CLASSPATH_FILENAME).toString();
        return resource.getFullPath().toString().equals(classPathFileName);
    }

    public static boolean isJavaProject(IResource resource) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return false;
    }

    public static boolean isTypeAjdtElement(IType type) {
        if (IS_AJDT_PRESENT) {
            return AjdtUtils.isTypeAjdtElement(type);
        }
        return false;
    }

    public static boolean isTypeGroovyElement(IType type) {
        ICompilationUnit cu = type.getCompilationUnit();
        if (cu != null && cu.getResource() != null) {
            return cu.getResource().getName().endsWith(GROOVY_FILE_EXTENSION);
        }
        if (cu != null) {
            try {
                IResource resource = cu.getUnderlyingResource();
                if (resource != null) {
                    return resource.getName().endsWith(GROOVY_FILE_EXTENSION);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public static String resolveClassName(String className, IType type) {
        if (className == null || type == null) {
            return className;
        }
        className = className.replace('$', '.');
        String dotClassName = '.' + className;
        IProject project = type.getJavaProject().getProject();
        try {
            String packageName;
            String newClassName;
            if (className.startsWith("java.lang") && JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            if (!type.isBinary()) {
                int ix = className.lastIndexOf(46);
                String firstClassNameSegment = className;
                if (ix > 0) {
                    firstClassNameSegment = className.substring(0, ix);
                }
                IImportDeclaration[] iImportDeclarationArray = type.getCompilationUnit().getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String newClassName2;
                    IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                    String importName = importDeclaration.getElementName();
                    if (importDeclaration.isOnDemand()) {
                        newClassName2 = importName.substring(0, importName.length() - 1) + className;
                        if (JdtUtils.getJavaType(project, newClassName2) != null) {
                            return newClassName2;
                        }
                    } else {
                        if (importName.endsWith(dotClassName) && JdtUtils.getJavaType(project, importName) != null) {
                            return importName;
                        }
                        if (!className.equals(firstClassNameSegment) && importName.endsWith(firstClassNameSegment) && JdtUtils.getJavaType(project, newClassName2 = importName.substring(0, importName.lastIndexOf(46) + 1) + className) != null) {
                            return newClassName2;
                        }
                    }
                    ++n2;
                }
            }
            if (JdtUtils.getJavaType(project, newClassName = (packageName = type.getPackageFragment().getElementName()) + dotClassName) != null) {
                return newClassName;
            }
            if (JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            newClassName = "java.lang" + dotClassName;
            if (JdtUtils.getJavaType(project, newClassName) != null) {
                return newClassName;
            }
            String[][] fullInter = type.resolveType(className);
            if (fullInter != null && fullInter.length > 0) {
                return String.valueOf(fullInter[0][0]) + "." + fullInter[0][1];
            }
        }
        catch (JavaModelException e) {
            SpringCore.log(e);
        }
        return className;
    }

    public static String resolveClassNameBySignature(String className, IType type) {
        if (className != null && className.length() > 0 && className.charAt(0) == 'L') {
            return Signature.toString((String)className).replace('$', '.');
        }
        className = Signature.toString((String)className).replace('$', '.');
        return JdtUtils.resolveClassName(className, type);
    }

    public static void visitTypeAst(IType type, ASTVisitor visitor) {
        if (type != null && type.getCompilationUnit() != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(type.getCompilationUnit());
            parser.setResolveBindings(true);
            ASTNode node = parser.createAST((IProgressMonitor)new NullProgressMonitor());
            node.accept(visitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doesImplementWithJdt(IResource resource, IType type, String className) {
        IType interfaceType = JdtUtils.getJavaType(resource.getProject(), className);
        if (type == null) return false;
        if (interfaceType == null) return false;
        try {
            IType[] subTypes = SuperTypeHierarchyCache.getTypeHierarchy(interfaceType).getAllSubtypes(interfaceType);
            if (subTypes == null) return false;
            IType[] iTypeArray = subTypes;
            int n = subTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType subType = iTypeArray[n2];
                if (subType.equals(type)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            SpringCore.log(ex);
        }
        return false;
    }

    private static String[] getParameterTypesAsStringArray(Class[] parameterTypes) {
        String[] parameterTypesAsString = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypesAsString[i] = ClassUtils.getQualifiedName((Class)parameterTypes[i]);
            ++i;
        }
        return parameterTypesAsString;
    }

    private static String[] getParameterTypesAsStringArray(IMethod method) {
        HashSet<String> typeParameterNames = new HashSet<String>();
        try {
            ITypeParameter param;
            ITypeParameter[] iTypeParameterArray = method.getDeclaringType().getTypeParameters();
            int n = iTypeParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                param = iTypeParameterArray[n2];
                typeParameterNames.add(param.getElementName());
                ++n2;
            }
            iTypeParameterArray = method.getTypeParameters();
            n = iTypeParameterArray.length;
            n2 = 0;
            while (n2 < n) {
                param = iTypeParameterArray[n2];
                typeParameterNames.add(param.getElementName());
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        String[] parameterTypesAsString = new String[method.getParameterTypes().length];
        int i = 0;
        while (i < method.getParameterTypes().length) {
            String parameterTypeString = Signature.getElementType((String)method.getParameterTypes()[i]);
            boolean isArray = !parameterTypeString.equals(method.getParameterTypes()[i]);
            String parameterType = JdtUtils.resolveClassNameBySignature(parameterTypeString, method.getDeclaringType());
            parameterTypesAsString[i] = typeParameterNames.contains(parameterType) ? String.valueOf(Object.class.getName()) + (isArray ? "[]" : "") : String.valueOf(parameterType) + (isArray ? "[]" : "");
            ++i;
        }
        return parameterTypesAsString;
    }

    public static Set<IType> searchForJavaConfigs(SearchPattern pattern, IJavaSearchScope scope) {
        final HashSet<IType> annotatedTypes = new HashSet<IType>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() == 0 && !match.isInsideDocComment()) {
                    IType type;
                    Object element = match.getElement();
                    if (element instanceof IType) {
                        annotatedTypes.add((IType)element);
                    } else if (element instanceof IMethod && (type = ((IMethod)element).getDeclaringType()) != null) {
                        annotatedTypes.add(type);
                    }
                }
            }
        };
        try {
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.core", "An error occurred while searching for Java config files.", (Throwable)e));
        }
        return annotatedTypes;
    }

    public static Set<IType> searchForJavaConfigs(IJavaSearchScope scope) {
        SearchPattern configurationPattern = SearchPattern.createPattern((String)"org.springframework.context.annotation.Configuration", (int)8, (int)65536, (int)8);
        SearchPattern componentPattern = SearchPattern.createPattern((String)"org.springframework.stereotype.Component", (int)8, (int)65536, (int)8);
        SearchPattern beanPattern = SearchPattern.createPattern((String)"org.springframework.context.annotation.Bean", (int)8, (int)65536, (int)8);
        SearchPattern importPattern = SearchPattern.createPattern((String)"org.springframework.context.annotation.Import", (int)8, (int)65536, (int)8);
        SearchPattern enableAutoConfigPattern = SearchPattern.createPattern((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration", (int)8, (int)65536, (int)8);
        SearchPattern bootAutoConfigPattern = SearchPattern.createPattern((String)"org.springframework.boot.autoconfigure.SpringBootApplication", (int)8, (int)65536, (int)8);
        SearchPattern pattern = SearchPattern.createOrPattern((SearchPattern)configurationPattern, (SearchPattern)componentPattern);
        pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)beanPattern);
        pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)importPattern);
        pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)enableAutoConfigPattern);
        pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)bootAutoConfigPattern);
        return JdtUtils.searchForJavaConfigs(pattern, scope);
    }

    static class DefaultProjectClassLoaderSupport
    implements IProjectClassLoaderSupport {
        private ClassLoader classLoader;
        private ClassLoader weavingClassLoader;

        public DefaultProjectClassLoaderSupport(IProject javaProject, ClassLoader parentClassLoader) {
            this.setupClassLoaders(javaProject, parentClassLoader);
        }

        @Override
        public void executeCallback(IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback callback) throws Throwable {
            try {
                this.activateWeavingClassLoader();
                callback.doWithActiveProjectClassLoader();
            }
            finally {
                this.recoverClassLoader();
            }
        }

        @Override
        public ClassLoader getProjectClassLoader() {
            return this.weavingClassLoader;
        }

        private void activateWeavingClassLoader() {
            Thread.currentThread().setContextClassLoader(this.weavingClassLoader);
        }

        private void recoverClassLoader() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }

        private void setupClassLoaders(IProject project, ClassLoader parentClassLoader) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            this.weavingClassLoader = ProjectClassLoaderCache.getClassLoader(project, parentClassLoader);
        }
    }
}

