/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io.xml;

import org.apache.xerces.impl.Version;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.io.xml.LineNumberPreservingDOMParser;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class XercesDocumentLoader
implements DocumentLoader {
    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        try {
            LineNumberPreservingDOMParser parser = new LineNumberPreservingDOMParser();
            parser.setEntityResolver(entityResolver);
            parser.setErrorHandler(errorHandler);
            if (validationMode != 0) {
                parser.setFeature("http://xml.org/sax/features/validation", false);
                parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                if (validationMode == 3) {
                    parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                }
            }
            parser.parse(inputSource);
            return parser.getDocument();
        }
        catch (LinkageError e) {
            this.logXercesLocation(e);
            throw new SAXException(SpringCore.getResourceString("Plugin.wrong_xerces_message"));
        }
        catch (ClassCastException e) {
            this.logXercesLocation(e);
            throw new SAXException(SpringCore.getResourceString("Plugin.wrong_xerces_message"));
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new SAXException(SpringCore.getResourceString("Plugin.wrong_xerces_message"));
        }
    }

    protected void logXercesLocation(Throwable throwable) throws SAXException {
        Class<Version> xercesVersion = Version.class;
        SpringCore.log(SpringCore.getFormattedMessage("Plugin.xerces_location", ClassUtils.getClassVersion(xercesVersion), ClassUtils.getClassLocation(xercesVersion), ClassUtils.getClassLoaderHierachy(xercesVersion)), throwable);
    }
}

