/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.springframework.ide.eclipse.config.graph.ConfigGraphPlugin;
import org.springframework.ide.eclipse.config.graph.actions.Messages;

public class ToggleLayoutAction
extends Action
implements IPropertyChangeListener {
    private String message;
    private final IPreferenceStore prefStore;
    private final String LAYOUT_PATH = "icons/layout.gif";
    private final String LAYOUT_DISABLED_PATH = "icons/layout_disabled.gif";

    public ToggleLayoutAction() {
        super(Messages.ToggleLayoutAction_ACTION_NAME, 2);
        ImageDescriptor imageDesc = ConfigGraphPlugin.imageDescriptorFromPlugin((String)"org.springframework.ide.eclipse.config.graph", (String)"icons/layout.gif");
        ImageDescriptor disabledDesc = ConfigGraphPlugin.imageDescriptorFromPlugin((String)"org.springframework.ide.eclipse.config.graph", (String)"icons/layout_disabled.gif");
        this.setImageDescriptor(imageDesc);
        this.setDisabledImageDescriptor(disabledDesc);
        this.prefStore = ConfigGraphPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setState();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.springsource.config.flow.prefs.manualLayout".equals(property)) {
            this.setState();
        }
    }

    public void run() {
        this.prefStore.setValue("com.springsource.config.flow.prefs.manualLayout", this.isChecked());
    }

    private void setState() {
        boolean state = this.prefStore.getBoolean("com.springsource.config.flow.prefs.manualLayout");
        this.message = state ? Messages.ToggleLayoutAction_TOOLTIP_ENABLE_AUTO_LAYOUT : Messages.ToggleLayoutAction_TOOLTIP_ENABLE_MANUAL_LAYOUT;
        this.setToolTipText(this.message);
        this.setChecked(state);
    }
}

