/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaApplicationLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.maintype.MainTypeFinder;

public class BootLaunchShortcut
extends JavaApplicationLaunchShortcut {
    public static final String LAUNCH_CONFIG_TYPE_ID = "org.springframework.ide.eclipse.boot.launch";

    public IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            Object e = objectArray[n2];
            if (e instanceof IProject) {
                try {
                    e = JavaCore.create((IProject)((IProject)e));
                }
                catch (Throwable throwable) {}
            }
            if ((type = this.isMainMethod(elements[0])) != null) {
                return new IType[]{type};
            }
            if (e instanceof IJavaElement) {
                if (e instanceof IType && this.hasMainMethod((IType)e)) {
                    return new IType[]{(IType)e};
                }
                if (e instanceof ICompilationUnit) {
                    IType[] iTypeArray = ((ICompilationUnit)e).getAllTypes();
                    int n3 = iTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType t = iTypeArray[n4];
                        if (this.hasMainMethod(t)) {
                            return new IType[]{t};
                        }
                        ++n4;
                    }
                }
                final IJavaProject jp = ((IJavaElement)e).getJavaProject();
                final IType[][] result = new IType[1][];
                try {
                    context.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                result[0] = MainTypeFinder.guessMainTypes((IJavaProject)jp, (IProgressMonitor)monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    throw ExceptionUtil.coreException((Throwable)exception);
                }
                return result[0];
            }
            ++n2;
        }
        return super.findTypes(elements, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMainMethod(IType t) {
        try {
            IMethod[] iMethodArray = t.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod m = iMethodArray[n2];
                if (m.isMainMethod()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return false;
    }

    private IType isMainMethod(Object o) {
        IAdaptable adapt;
        IJavaElement element;
        if (o instanceof IAdaptable && (element = (IJavaElement)(adapt = (IAdaptable)o).getAdapter(IJavaElement.class)) != null && element.getElementType() == 9) {
            try {
                IMethod method = (IMethod)element;
                if (method.isMainMethod()) {
                    return method.getDeclaringType();
                }
            }
            catch (JavaModelException jme) {
                JDIDebugUIPlugin.log((Throwable)jme);
            }
        }
        return null;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIG_TYPE_ID);
    }

    public ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            config = BootLaunchConfigurationDelegate.createConf(type);
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
        }
        return config;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static void launch(IProject project, String mode) {
        BootLaunchShortcut shortcut = new BootLaunchShortcut();
        StructuredSelection selection = new StructuredSelection(new Object[]{project});
        shortcut.launch((ISelection)selection, mode);
    }
}

