/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.springframework.ide.eclipse.config.ui.wizards.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class ExtendedNewClassWizardPage
extends NewClassWizardPage {
    private final IProject project;
    private IJavaProject javaProject;
    private String className;
    private final InitialClassProperties initialValues;

    public ExtendedNewClassWizardPage(IProject project, String className) {
        this.className = className;
        this.project = project;
        try {
            this.javaProject = project.hasNature("org.eclipse.jdt.core.javanature") ? JavaCore.create((IProject)project) : null;
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("ExtendedNewClassWizardPage.ERROR_CREATING_WIZARD_PAGE"), (Throwable)e));
        }
        this.initialValues = new InitialClassProperties();
        this.initialValues.className = className;
    }

    private IType findTypeForName(String typeName) throws JavaModelException {
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        IType type = null;
        String fileName = String.valueOf(typeName.replace('.', '/')) + ".java";
        IJavaElement element = this.javaProject.findElement((IPath)new Path(fileName));
        if (element == null) {
            return null;
        }
        if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getTypes();
            type = types[0];
        }
        return type;
    }

    public void init() {
        this.initializeExpectedValues();
        this.initializeWizardPage();
    }

    private void initializeExpectedValues() {
        int loc = this.className.indexOf(":");
        if (loc != -1) {
            if (loc < this.className.length()) {
                this.initialValues.classArgs = this.className.substring(loc + 1, this.className.length());
                this.className = this.className.substring(0, loc);
            }
            if (loc > 0) {
                this.initialValues.className = this.className.substring(0, loc);
            } else if (loc == 0) {
                this.initialValues.className = "";
            }
        }
        if ((loc = this.className.lastIndexOf(46)) != -1) {
            this.initialValues.packageName = this.className.substring(0, loc);
            this.initialValues.className = this.className.substring(loc + 1);
        }
        if (this.javaProject == null) {
            return;
        }
        try {
            if (this.initialValues.packageFragmentRoot == null) {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot srcEntryDft = null;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.javaProject.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1) {
                        srcEntryDft = root;
                        break;
                    }
                    ++n2;
                }
                this.initialValues.packageFragmentRoot = srcEntryDft != null ? srcEntryDft : this.javaProject.getPackageFragmentRoot(this.javaProject.getResource());
                if (this.initialValues.packageFragment == null && this.initialValues.packageFragmentRoot != null && this.initialValues.packageName != null && this.initialValues.packageName.length() > 0) {
                    IFolder packageFolder = this.project.getFolder(this.initialValues.packageName);
                    this.initialValues.packageFragment = this.initialValues.packageFragmentRoot.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
                }
            }
            this.initialValues.superClassName = "java.lang.Object";
            this.initialValues.superClassType = this.findTypeForName(this.initialValues.superClassName);
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("ExtendedNewClassWizardPage.ERROR_INITIALIZING_WIZARD_PAGE"), (Throwable)e));
        }
    }

    private void initializeWizardPage() {
        this.setPackageFragmentRoot(this.initialValues.packageFragmentRoot, true);
        this.setPackageFragment(this.initialValues.packageFragment, true);
        this.setEnclosingType(null, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(this.initialValues.className, true);
        this.setSuperClass(this.initialValues.superClassName, true);
        if (this.initialValues.interfaceName != null) {
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add(this.initialValues.interfaceName);
            this.setSuperInterfaces(interfaces, true);
        }
        boolean hasSuperClass = this.initialValues.superClassName != null && this.initialValues.superClassName.length() > 0;
        boolean hasInterface = this.initialValues.interfaceName != null && this.initialValues.interfaceName.length() > 0;
        this.setMethodStubSelection(false, hasSuperClass, hasInterface || hasSuperClass, true);
    }

    class InitialClassProperties {
        IType superClassType = null;
        String superClassName = "";
        IType interfaceType = null;
        String interfaceName = null;
        String className = null;
        String classArgs = null;
        String packageName = null;
        IPackageFragmentRoot packageFragmentRoot = null;
        IPackageFragment packageFragment = null;
    }
}

