/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigSectionPart;
import org.springframework.ide.eclipse.config.ui.properties.SpringConfigPropertySheetPage;

public abstract class AbstractConfigPropertySection
extends AbstractPropertySection {
    private AbstractConfigEditor editor;
    protected IDOMElement input;
    protected ScrolledPageBook pageBook;
    protected Map<IDOMElement, AbstractConfigSectionPart> partMap = new HashMap<IDOMElement, AbstractConfigSectionPart>();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayoutData((Object)new GridData(1808));
        if (aTabbedPropertySheetPage instanceof SpringConfigPropertySheetPage) {
            SpringConfigPropertySheetPage page = (SpringConfigPropertySheetPage)aTabbedPropertySheetPage;
            this.editor = page.getConfigEditor();
            this.editor.addPropertiesPage(this);
        }
        this.pageBook = this.getWidgetFactory().createPageBook(parent, 768);
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertiesPage(this);
        }
        super.dispose();
    }

    protected AbstractConfigEditor getConfigEditor() {
        return this.editor;
    }

    public IDOMElement getInput() {
        return this.input;
    }

    public void refresh() {
        AbstractConfigSectionPart sectionPart;
        if (this.input != null && (sectionPart = this.partMap.get(this.input)) != null) {
            sectionPart.refresh();
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.input = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            Object obj = struct.getFirstElement();
            if (obj instanceof IDOMElement) {
                this.input = (IDOMElement)obj;
            } else if (obj instanceof TreeItem) {
                TreeItem item = (TreeItem)obj;
                if (item.getData() instanceof IDOMElement) {
                    this.input = (IDOMElement)item.getData();
                }
            } else if (obj instanceof ActivityPart) {
                ActivityPart activity = (ActivityPart)obj;
                this.input = activity.getModelElement().getInput();
            } else if (obj instanceof TransitionPart) {
                TransitionPart trans = (TransitionPart)obj;
                IDOMNode node = ((Transition)trans.getModel()).getInput();
                if (node instanceof IDOMElement) {
                    this.input = (IDOMElement)node;
                } else if (node instanceof IDOMAttr) {
                    this.input = (IDOMElement)((IDOMAttr)node).getOwnerElement();
                }
            }
        }
    }
}

