/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;

public class ReconnectTargetChannelCommand
extends AbstractTextCommand {
    private Activity source;
    private Activity target;
    private Transition transition;
    private IDOMElement sourceElement;
    private IDOMElement targetElement;
    private IDOMElement transitionElement;
    private Activity oldTarget;
    private IDOMElement oldTargetElement;
    private String oldTargetId;
    private String targetId;

    public ReconnectTargetChannelCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        if (this.source == null || this.target == null || this.source.equals((Object)this.target) || this.oldTarget.equals((Object)this.target)) {
            return false;
        }
        this.sourceElement = this.source.getInput();
        this.targetElement = this.target.getInput();
        this.oldTargetElement = this.oldTarget.getInput();
        this.transitionElement = (IDOMElement)this.transition.getInput();
        if (this.sourceElement == null || this.targetElement == null || this.oldTargetElement == null) {
            return false;
        }
        if (!(this.transition.getInput() instanceof IDOMElement)) {
            return false;
        }
        this.oldTargetId = this.transitionElement.getAttribute(IntegrationSchemaConstants.ATTR_CHANNEL);
        this.targetId = this.targetElement.getAttribute(IntegrationSchemaConstants.ATTR_ID);
        return this.targetId != null && this.targetId.trim().length() > 0;
    }

    public void execute() {
        this.transitionElement.setAttribute(IntegrationSchemaConstants.ATTR_CHANNEL, this.targetId);
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.source = trans.source;
        this.oldTarget = trans.target;
    }
}

