/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.CatchClause;
import org.aspectj.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.Statement;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationExpression;

public class TryStatement
extends Statement {
    public static final ChildListPropertyDescriptor RESOURCES_PROPERTY = new ChildListPropertyDescriptor(TryStatement.class, "resources", VariableDeclarationExpression.class, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(TryStatement.class, "body", Block.class, true, true);
    public static final ChildListPropertyDescriptor CATCH_CLAUSES_PROPERTY = new ChildListPropertyDescriptor(TryStatement.class, "catchClauses", CatchClause.class, true);
    public static final ChildPropertyDescriptor FINALLY_PROPERTY = new ChildPropertyDescriptor(TryStatement.class, "finally", Block.class, false, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_4_0;
    private ASTNode.NodeList resources = null;
    private Block body = null;
    private ASTNode.NodeList catchClauses = new ASTNode.NodeList(CATCH_CLAUSES_PROPERTY);
    private Block optionalFinallyBody = null;

    static {
        ArrayList propertyList = new ArrayList(4);
        TryStatement.createPropertyList(TryStatement.class, propertyList);
        TryStatement.addProperty(BODY_PROPERTY, propertyList);
        TryStatement.addProperty(CATCH_CLAUSES_PROPERTY, propertyList);
        TryStatement.addProperty(FINALLY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TryStatement.reapPropertyList(propertyList);
        propertyList = new ArrayList(5);
        TryStatement.createPropertyList(TryStatement.class, propertyList);
        TryStatement.addProperty(RESOURCES_PROPERTY, propertyList);
        TryStatement.addProperty(BODY_PROPERTY, propertyList);
        TryStatement.addProperty(CATCH_CLAUSES_PROPERTY, propertyList);
        TryStatement.addProperty(FINALLY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_4_0 = TryStatement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        switch (apiLevel) {
            case 2: 
            case 3: {
                return PROPERTY_DESCRIPTORS;
            }
        }
        return PROPERTY_DESCRIPTORS_4_0;
    }

    TryStatement(AST ast) {
        super(ast);
        if (ast.apiLevel >= 4) {
            this.resources = new ASTNode.NodeList(RESOURCES_PROPERTY);
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TryStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == FINALLY_PROPERTY) {
            if (get) {
                return this.getFinally();
            }
            this.setFinally((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == RESOURCES_PROPERTY) {
            return this.resources();
        }
        if (property == CATCH_CLAUSES_PROPERTY) {
            return this.catchClauses();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 54;
    }

    @Override
    ASTNode clone0(AST target) {
        TryStatement result = new TryStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        if (this.ast.apiLevel >= 4) {
            result.resources().addAll(ASTNode.copySubtrees(target, this.resources()));
        }
        result.setBody((Block)this.getBody().clone(target));
        result.catchClauses().addAll(ASTNode.copySubtrees(target, this.catchClauses()));
        result.setFinally((Block)ASTNode.copySubtree(target, this.getFinally()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 4) {
                this.acceptChildren(visitor, this.resources);
            }
            this.acceptChild(visitor, this.getBody());
            this.acceptChildren(visitor, this.catchClauses);
            this.acceptChild(visitor, this.getFinally());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block getBody() {
        if (this.body == null) {
            TryStatement tryStatement = this;
            synchronized (tryStatement) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public List catchClauses() {
        return this.catchClauses;
    }

    public Block getFinally() {
        return this.optionalFinallyBody;
    }

    public void setFinally(Block block) {
        Block oldChild = this.optionalFinallyBody;
        this.preReplaceChild(oldChild, block, FINALLY_PROPERTY);
        this.optionalFinallyBody = block;
        this.postReplaceChild(oldChild, block, FINALLY_PROPERTY);
    }

    public List resources() {
        if (this.resources == null) {
            this.unsupportedIn2_3();
        }
        return this.resources;
    }

    @Override
    int memSize() {
        return super.memSize() + 16;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.resources == null ? 0 : this.resources.listSize()) + (this.body == null ? 0 : this.getBody().treeSize()) + this.catchClauses.listSize() + (this.optionalFinallyBody == null ? 0 : this.getFinally().treeSize());
    }
}

