/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.remoteapi;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.Server;
import com.atlassian.theplugin.commons.cfg.ServerId;
import com.atlassian.theplugin.commons.cfg.UserCfg;

public class ServerData
extends ConnectionCfg {
    private final Server server;
    private boolean useProxy = false;
    private UserCfg basicUser;
    private UserCfg proxyUser;
    private boolean useBasicUser = false;
    private boolean useSessionCookies = false;

    public ServerData(Builder builder) {
        super(builder.server != null && builder.server.getServerId() != null ? builder.server.getServerId().getId() : "", builder.server != null ? builder.server.getUrl() : "", builder.useDefaultUser ? builder.defaultUser.getUsername() : (builder.server != null ? builder.server.getUsername() : ""), builder.useDefaultUser ? builder.defaultUser.getPassword() : (builder.server != null ? builder.server.getPassword() : ""));
        this.server = builder.server;
        this.basicUser = builder.basicUser;
        this.useProxy = builder.useProxyUser;
        this.proxyUser = builder.proxyUser;
        this.useBasicUser = builder.useBasicUser;
        this.useSessionCookies = builder.useSessionCookies;
    }

    private ServerData(ServerData that) {
        super(that.getId(), that.getUrl(), that.getUsername(), that.getPassword());
        this.server = that.server;
        this.useProxy = that.useProxy;
        this.basicUser = that.basicUser;
        this.proxyUser = that.proxyUser;
        this.useBasicUser = that.useBasicUser;
        this.useSessionCookies = that.useSessionCookies;
    }

    public ServerData(Server server) {
        super(server != null ? (server.getServerId() != null ? server.getServerId().getId() : "") : "", server != null ? server.getUrl() : "", server != null ? server.getUsername() : "", server != null ? server.getPassword() : "");
        this.server = server;
        if (server != null) {
            this.useBasicUser = !server.isDontUseBasicAuth();
            this.basicUser = server.getBasicHttpUser();
        }
    }

    public ServerData(Server server, UserCfg defaultUser) {
        super(server != null && server.getServerId() != null ? server.getServerId().getId() : "", server != null ? server.getUrl() : "", defaultUser != null ? defaultUser.getUsername() : (server != null ? server.getUsername() : ""), defaultUser != null ? defaultUser.getPassword() : (server != null ? server.getPassword() : ""));
        this.server = server;
    }

    protected Server getServer() {
        return this.server;
    }

    public String getUsername() {
        return super.getUsername();
    }

    public String getPassword() {
        return super.getPassword();
    }

    public String getUrl() {
        return this.server.getUrl();
    }

    public ServerId getServerId() {
        return this.server.getServerId();
    }

    public String getName() {
        return this.server.getName();
    }

    public boolean isEnabled() {
        return this.server.isEnabled();
    }

    public ServerType getServerType() {
        return this.server.getServerType();
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public UserCfg getBasicUser() {
        return this.basicUser;
    }

    public UserCfg getProxyUser() {
        return this.proxyUser;
    }

    public boolean isUseBasicUser() {
        return this.useBasicUser;
    }

    public boolean isUseSessionCookies() {
        return this.useSessionCookies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ServerData)) {
            return false;
        }
        ServerData that = (ServerData)o;
        if (this.getServerId() != null ? !this.getServerId().equals(that.getServerId()) : that.getServerId() != null) {
            return false;
        }
        if (this.getUrl() != null ? !this.getUrl().equals(that.getUrl()) : that.getUrl() != null) {
            return false;
        }
        if (this.getPassword() == null ? that.getPassword() != null : !this.getPassword().equals(that.getPassword())) {
            return false;
        }
        return !(this.getUsername() == null ? that.getUsername() != null : !this.getUsername().equals(that.getUsername()));
    }

    public int hashCode() {
        int result = this.getServerId() != null ? this.getServerId().hashCode() : 0;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.getUrl() != null ? this.getUrl().hashCode() : 0);
        return result;
    }

    public ConnectionCfg toConnectionCfg() {
        return new ServerData(this);
    }

    public static class Builder {
        protected final Server server;
        protected UserCfg defaultUser;
        protected UserCfg basicUser;
        protected UserCfg proxyUser;
        protected boolean useDefaultUser = false;
        protected boolean useProxyUser = false;
        private boolean useBasicUser;
        private boolean useSessionCookies = false;

        public Builder(Server server) {
            this.server = server;
            this.basicUser = server.getBasicHttpUser();
            this.useBasicUser = !server.isDontUseBasicAuth();
            this.useDefaultUser = server.isUseDefaultCredentials();
            this.useSessionCookies = server.isUseSessionCookies();
        }

        public Builder(Server server, UserCfg defaultUser) {
            this(server);
            this.defaultUser = defaultUser;
        }

        protected Server getServer() {
            return this.server;
        }

        public void basicUser(UserCfg basicUsr) {
            this.basicUser = basicUsr;
        }

        public void defaultUser(UserCfg defaultUsr) {
            this.defaultUser = defaultUsr;
        }

        public void proxyUser(UserCfg proxyUsr) {
            this.proxyUser = proxyUsr;
        }

        public void useDefaultUser(boolean useDefault) {
            this.useDefaultUser = useDefault;
        }

        public void useProxyUser(boolean useProxy) {
            this.useProxyUser = useProxy;
        }

        public void useBasicUser(boolean useBasic) {
            this.useBasicUser = useBasic;
        }

        public ServerData build() {
            return new ServerData(this);
        }

        public void setUseSessionCookies(boolean useSessionCookies) {
            this.useSessionCookies = useSessionCookies;
        }
    }
}

