/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model.notification;

import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.notification.CrucibleNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.CrucibleNotificationType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReviewNotification
implements CrucibleNotification {
    protected Review review;

    public AbstractReviewNotification(Review review) {
        this.review = review;
    }

    public abstract CrucibleNotificationType getType();

    public PermId getId() {
        return this.review.getPermId();
    }

    @NotNull
    public String getItemUrl() {
        String baseUrl = this.review.getServerUrl();
        while (baseUrl.length() > 0 && baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return String.valueOf(baseUrl) + "/cru/" + this.review.getPermId().getId();
    }

    public abstract String getPresentationMessage();
}

