/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.configuration;

import com.atlassian.theplugin.commons.configuration.CheckNowButtonOption;
import com.atlassian.theplugin.commons.util.Version;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralConfigurationBean {
    private boolean autoUpdateEnabled = true;
    private Version rejectedUpgrade = Version.NULL_VERSION;
    private boolean checkUnstableVersionsEnabled;
    private Boolean anonymousEnhancedFeedbackEnabled;
    private boolean useIdeaProxySettings = true;
    private boolean httpServerEnabled = true;
    private Collection<String> certs = new HashSet<String>();
    private Map<String, Integer> statsCountersMap = Collections.synchronizedMap(new HashMap());
    private long uid = 0L;
    private static final double ID_DISCRIMINATOR = 1000.0;
    private CheckNowButtonOption checkNowButtonOption = CheckNowButtonOption.ONLY_STABLE;
    public static final int HTTP_SERVER_PORT = 51235;
    private int httpServerPort = 51235;
    private boolean askedAboutDefaultServers = false;
    private boolean informedAboutIdea9TaskExperimentalSupport = false;
    private static final int THIRTY_ONE = 31;
    private static final int THIRTY_TWO = 32;

    public GeneralConfigurationBean() {
    }

    public GeneralConfigurationBean(GeneralConfigurationBean generalConfigurationData) {
        this.anonymousEnhancedFeedbackEnabled = generalConfigurationData.getAnonymousEnhancedFeedbackEnabled();
        this.rejectedUpgrade = generalConfigurationData.getRejectedUpgrade();
        this.checkUnstableVersionsEnabled = generalConfigurationData.isCheckUnstableVersionsEnabled();
        this.autoUpdateEnabled = generalConfigurationData.isAutoUpdateEnabled();
        this.httpServerEnabled = generalConfigurationData.isHttpServerEnabled();
        this.httpServerPort = generalConfigurationData.getHttpServerPort();
        this.uid = generalConfigurationData.getUid();
        this.useIdeaProxySettings = generalConfigurationData.getUseIdeaProxySettings();
        this.certs = generalConfigurationData.getCerts();
        this.statsCountersMap = Collections.synchronizedMap(generalConfigurationData.getStatsCountersMap());
        this.checkNowButtonOption = generalConfigurationData.getCheckNowButtonOption();
        this.askedAboutDefaultServers = generalConfigurationData.isAskedAboutDefaultServers();
        this.informedAboutIdea9TaskExperimentalSupport = generalConfigurationData.isInformedAboutIdea9TaskExperimentalSupport();
    }

    public long getUid() {
        if (this.uid == 0L) {
            this.uid = System.currentTimeMillis() + (long)(Math.random() * 1000.0);
        }
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public boolean isAutoUpdateEnabled() {
        return this.autoUpdateEnabled;
    }

    public void setAutoUpdateEnabled(boolean autoUpdateEnabled) {
        this.autoUpdateEnabled = autoUpdateEnabled;
    }

    public boolean isHttpServerEnabled() {
        return this.httpServerEnabled;
    }

    public void setHttpServerEnabled(boolean httpServerEnabled) {
        this.httpServerEnabled = httpServerEnabled;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int port) {
        this.httpServerPort = port;
    }

    public Version getRejectedUpgrade() {
        return this.rejectedUpgrade;
    }

    public void setRejectedUpgrade(Version rejectedUpgrade) {
        this.rejectedUpgrade = rejectedUpgrade;
    }

    public void setCheckUnstableVersionsEnabled(boolean checkUnstableVersionsEnabled) {
        this.checkUnstableVersionsEnabled = checkUnstableVersionsEnabled;
    }

    public boolean isCheckUnstableVersionsEnabled() {
        return this.checkUnstableVersionsEnabled;
    }

    public Boolean getAnonymousEnhancedFeedbackEnabled() {
        return this.anonymousEnhancedFeedbackEnabled;
    }

    public void setAnonymousEnhancedFeedbackEnabled(Boolean isAnonymousEnhancedFeedbackEnabled) {
        this.anonymousEnhancedFeedbackEnabled = isAnonymousEnhancedFeedbackEnabled;
    }

    public boolean getUseIdeaProxySettings() {
        return this.useIdeaProxySettings;
    }

    public synchronized Collection<String> getCerts() {
        return this.certs;
    }

    public synchronized void setCerts(Collection<String> certs) {
        this.certs = certs;
    }

    public void setUseIdeaProxySettings(boolean use) {
        this.useIdeaProxySettings = use;
    }

    public CheckNowButtonOption getCheckNowButtonOption() {
        return this.checkNowButtonOption;
    }

    public void setCheckNowButtonOption(CheckNowButtonOption checkNowButtonOption) {
        this.checkNowButtonOption = checkNowButtonOption;
    }

    public Map<String, Integer> getStatsCountersMap() {
        return this.statsCountersMap;
    }

    public synchronized void addCounterIfNotPresent(String counterName) {
        if (!this.getStatsCountersMap().containsKey(counterName)) {
            this.getStatsCountersMap().put(counterName, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bumpCounter(String counterName) {
        Boolean enabled = this.getAnonymousEnhancedFeedbackEnabled();
        if (enabled == null || !enabled.booleanValue()) {
            return;
        }
        Map<String, Integer> map = this.getStatsCountersMap();
        synchronized (map) {
            if (this.getStatsCountersMap().containsKey(counterName)) {
                this.getStatsCountersMap().put(counterName, this.getStatsCountersMap().get(counterName) + 1);
            } else {
                this.getStatsCountersMap().put(counterName, 1);
            }
        }
    }

    public boolean isAskedAboutDefaultServers() {
        return this.askedAboutDefaultServers;
    }

    public boolean isInformedAboutIdea9TaskExperimentalSupport() {
        return this.informedAboutIdea9TaskExperimentalSupport;
    }

    public void setInformedAboutIdea9TaskExperimentalSupport(boolean informedAboutIdea9TaskExperimentalSupport) {
        this.informedAboutIdea9TaskExperimentalSupport = informedAboutIdea9TaskExperimentalSupport;
    }

    public void setAskedAboutDefaultServers(boolean askedAboutDefaultServers) {
        this.askedAboutDefaultServers = askedAboutDefaultServers;
    }

    public void resetCounter(String counterName) {
        this.getStatsCountersMap().put(counterName, 0);
    }

    public void setStatsCountersMap(Map<String, Integer> statsCountersMap) {
        this.statsCountersMap = Collections.synchronizedMap(statsCountersMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralConfigurationBean that = (GeneralConfigurationBean)o;
        if (this.autoUpdateEnabled != that.autoUpdateEnabled) {
            return false;
        }
        if (this.httpServerEnabled != that.httpServerEnabled) {
            return false;
        }
        if (this.askedAboutDefaultServers != that.askedAboutDefaultServers) {
            return false;
        }
        if (this.httpServerPort != that.httpServerPort) {
            return false;
        }
        if (this.checkUnstableVersionsEnabled != that.checkUnstableVersionsEnabled) {
            return false;
        }
        if (this.uid != that.uid) {
            return false;
        }
        if (this.useIdeaProxySettings != that.useIdeaProxySettings) {
            return false;
        }
        if (this.anonymousEnhancedFeedbackEnabled != null ? !this.anonymousEnhancedFeedbackEnabled.equals(that.anonymousEnhancedFeedbackEnabled) : that.anonymousEnhancedFeedbackEnabled != null) {
            return false;
        }
        if (this.checkNowButtonOption != null ? !this.checkNowButtonOption.equals((Object)that.checkNowButtonOption) : that.checkNowButtonOption != null) {
            return false;
        }
        if (this.rejectedUpgrade != null ? !this.rejectedUpgrade.equals(that.rejectedUpgrade) : that.rejectedUpgrade != null) {
            return false;
        }
        if (this.certs != null && !this.certs.equals(that.certs)) {
            return false;
        }
        return this.statsCountersMap.equals(that.statsCountersMap);
    }

    public int hashCode() {
        int result = this.autoUpdateEnabled ? 1 : 0;
        result = 31 * result + (this.informedAboutIdea9TaskExperimentalSupport ? 1 : 0);
        result = 31 * result + (this.askedAboutDefaultServers ? 1 : 0);
        result = 31 * result + (this.httpServerEnabled ? 1 : 0);
        result = 31 * result + this.httpServerPort;
        result = 31 * result + (this.rejectedUpgrade != null ? this.rejectedUpgrade.hashCode() : 0);
        result = 31 * result + (this.checkUnstableVersionsEnabled ? 1 : 0);
        result = 31 * result + (this.useIdeaProxySettings ? 1 : 0);
        result = 31 * result + (this.anonymousEnhancedFeedbackEnabled != null ? this.anonymousEnhancedFeedbackEnabled.hashCode() : 0);
        result = 31 * result + (this.checkNowButtonOption != null ? this.checkNowButtonOption.hashCode() : 0);
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        result = 31 * result + this.certs.hashCode();
        result = 31 * result + this.statsCountersMap.hashCode();
        return result;
    }

    public synchronized void addCert(String strCert) {
        this.certs.add(strCert);
    }
}

