/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.misc;

public final class IntRange {
    private final int min;
    private final int max;
    private static final int MAGIC = 31;

    public IntRange(int number) {
        this.min = number;
        this.max = number;
    }

    public boolean isSingleNumber() {
        return this.min == this.max;
    }

    public IntRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Lower bound [" + min + "] cannot be greater than upper bound [" + max + "]");
        }
        this.max = max;
        this.min = min;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        if (this.isSingleNumber()) {
            return "[" + this.min + "]";
        }
        return "[" + this.min + "-" + this.max + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRange intRange = (IntRange)o;
        if (this.max != intRange.max) {
            return false;
        }
        return this.min == intRange.min;
    }

    public int hashCode() {
        int result = this.min;
        result = 31 * result + this.max;
        return result;
    }

    public String toNiceString() {
        if (this.isSingleNumber()) {
            return String.valueOf(this.min);
        }
        return String.valueOf(this.min) + " - " + this.max;
    }
}

