/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.maintype;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.maintype.IMainTypeFinder;
import org.springsource.ide.eclipse.commons.frameworks.core.maintype.PomParser;

public class MainTypeFinder {
    private static MainTypeFinder instance;
    private static final IType[] EMPTY;
    private Map<Confidence, IMainTypeFinder[]> algos = new LinkedHashMap<Confidence, IMainTypeFinder[]>();
    private static final String MAIN_CLASS_PROP = "start-class";

    static {
        EMPTY = new IType[0];
    }

    public static IType[] guessMainTypes(IJavaProject project, IProgressMonitor mon) throws CoreException {
        return MainTypeFinder.getInstance().internalGuessMainTypes(project, mon);
    }

    private static synchronized MainTypeFinder getInstance() {
        if (instance == null) {
            instance = new MainTypeFinder();
        }
        return instance;
    }

    private MainTypeFinder() {
        this.algos.put(Confidence.CERTAIN, new IMainTypeFinder[0]);
        this.algos.put(Confidence.HIGH, new IMainTypeFinder[]{new FindInPom()});
        this.algos.put(Confidence.LOW, new IMainTypeFinder[]{new FindInSource()});
    }

    private IType[] internalGuessMainTypes(IJavaProject project, IProgressMonitor mon) throws CoreException {
        Throwable error = null;
        mon.beginTask("Search main types", this.algos.size());
        LinkedHashSet<IType> totalTypes = new LinkedHashSet<IType>();
        try {
            for (Map.Entry<Confidence, IMainTypeFinder[]> entry : this.algos.entrySet()) {
                IMainTypeFinder[] iMainTypeFinderArray = entry.getValue();
                int n = iMainTypeFinderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block10: {
                        IMainTypeFinder algo = iMainTypeFinderArray[n2];
                        try {
                            IType[] found;
                            IType[] iTypeArray = found = algo.findMain(project, (IProgressMonitor)new SubProgressMonitor(mon, 1));
                            int n3 = found.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IType type = iTypeArray[n4];
                                totalTypes.add(type);
                                ++n4;
                            }
                        }
                        catch (Throwable e) {
                            if (error != null) break block10;
                            error = e;
                        }
                    }
                    ++n2;
                }
                if (!totalTypes.isEmpty()) break;
            }
            mon.worked(1);
        }
        finally {
            mon.done();
        }
        if (!totalTypes.isEmpty()) {
            return totalTypes.toArray(new IType[0]);
        }
        if (error != null) {
            throw ExceptionUtil.coreException(error);
        }
        return EMPTY;
    }

    public static enum Confidence {
        CERTAIN,
        HIGH,
        LOW;

    }

    public static class FindInPom
    implements IMainTypeFinder {
        @Override
        public IType[] findMain(IJavaProject jp, IProgressMonitor mon) throws Exception {
            mon.beginTask("Search main in pom", 1);
            try {
                PomParser pomParser;
                String starterClassName;
                IProject p = jp.getProject();
                IFile pomFile = p.getFile("pom.xml");
                if (pomFile.exists() && (starterClassName = (pomParser = new PomParser(pomFile)).getProperty(MainTypeFinder.MAIN_CLASS_PROP)) != null) {
                    IType mainType = jp.findType(starterClassName);
                    if (mainType != null) {
                        IType[] iTypeArray = new IType[]{mainType};
                        return iTypeArray;
                    }
                    throw ExceptionUtil.coreException("'pom.xml' defines 'start-class' as '" + starterClassName + "' but it could not be found");
                }
            }
            finally {
                mon.done();
            }
            return EMPTY;
        }
    }

    public static class FindInSource
    implements IMainTypeFinder {
        @Override
        public IType[] findMain(IJavaProject javaProject, IProgressMonitor monitor) throws Exception {
            monitor.beginTask("Search main types in project source", 1);
            try {
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                int constraints = 1;
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)constraints);
                boolean includeSubtypes = true;
                IType[] types = engine.searchMainMethods(monitor, scope, includeSubtypes);
                if (types == null) {
                    types = EMPTY;
                }
                IType[] iTypeArray = types;
                return iTypeArray;
            }
            finally {
                monitor.done();
            }
        }
    }
}

