/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;

public abstract class AbstractLegacyConverter
implements IConversionConstants {
    public abstract IStatus convert(IProgressMonitor var1);

    protected void copyPluginStateLocation(String from, String to) throws IOException {
        File oldPreferencesFolder = FrameworkCoreActivator.getDefault().getStateLocation().removeLastSegments(1).append(from).toFile();
        if (oldPreferencesFolder.exists() && oldPreferencesFolder.isDirectory()) {
            File newPreferencesFolder = FrameworkCoreActivator.getDefault().getStateLocation().removeLastSegments(1).append(to).toFile();
            this.copyDirectory(oldPreferencesFolder, newPreferencesFolder);
        }
    }

    private void copyDirectory(File oldFolder, File newFolder) throws IOException {
        if (!newFolder.exists()) {
            newFolder.mkdir();
        }
        File[] fileArray = oldFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File oldFile = fileArray[n2];
            String oldName = oldFile.getName();
            String newName = oldName.replace("com.springsource.sts.grails.core", "org.grails.ide.eclipse.core");
            newName = newName.replace("com.springsource.sts.roo.core", "org.springframework.ide.eclipse.roo.core");
            File newFile = new File(newFolder, newName);
            if (oldFile.isDirectory()) {
                this.copyDirectory(new File(oldFolder, oldName), new File(newFolder, newName));
            } else {
                AbstractLegacyConverter.copyFile(oldFile, newFile);
            }
            ++n2;
        }
    }

    protected void copyPreferencesFile(File settingsFile, File newSettingsFile, String oldPrefix, String newPrefix) throws IOException, CoreException, FileNotFoundException {
        if (settingsFile.exists()) {
            Properties oldProps = new Properties();
            oldProps.load(new FileInputStream(settingsFile));
            Properties newProps = new Properties();
            for (Map.Entry<Object, Object> prop : oldProps.entrySet()) {
                String oldKey = prop.getKey().toString();
                String newKey = oldPrefix != null && oldKey.startsWith(oldPrefix) ? oldKey.replace(oldPrefix, newPrefix) : oldKey;
                newProps.put(newKey, prop.getValue());
            }
            newProps.store(new FileOutputStream(newSettingsFile), "");
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

