/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.beans.core.model.locate.ProjectScanningBeansConfigLocator;
import org.springframework.ide.eclipse.beans.core.model.locate.ProjectScanningJavaConfigLocator;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.properties.NonJavaResourceContentProvider;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.ui.dialogs.FilteredElementTreeSelectionDialog;
import org.springframework.ide.eclipse.ui.dialogs.StorageSelectionValidator;
import org.springframework.ide.eclipse.ui.viewers.JavaFileSuffixFilter;
import org.springsource.ide.eclipse.commons.core.JdtUtils;
import org.springsource.ide.eclipse.commons.core.SpringCorePreferences;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class ConfigFilesTab {
    private static final String PREFIX = "ConfigurationPropertyPage.tabConfigFiles.";
    private static final String DESCRIPTION = "ConfigurationPropertyPage.tabConfigFiles.description";
    private static final String SUFFIXES_LABEL = "ConfigurationPropertyPage.tabConfigFiles.suffixes.label";
    private static final String ERROR_NO_SUFFIXES = "ConfigurationPropertyPage.tabConfigFiles.error.noSuffixes";
    private static final String ERROR_INVALID_SUFFIXES = "ConfigurationPropertyPage.tabConfigFiles.error.invalidSuffixes";
    private static final String ADD_XML_CONFIG_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.addXMLConfigButton";
    private static final String ADD_JAVA_CONFIG_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.addJavaConfigButton";
    private static final String REMOVE_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.removeButton";
    private static final String DIALOG_TITLE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.title";
    private static final String DIALOG_MESSAGE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.message";
    private static final int TABLE_WIDTH = 250;
    private static final String ENABLE_IMPORT_LABEL = "ConfigurationPropertyPage.tabConfigFiles.enableImports.label";
    private static final String IGNORE_MISSING_NAMESPACEHANDLER_LABEL = "ConfigurationPropertyPage.tabConfigFiles.ignoreMissingNamespaceHandler.label";
    private static final String NOTE_LABEL = "ConfigurationPropertyPage.tabConfigFiles.note.label";
    private static final String SCAN_NOTE_LABEL = "ConfigurationPropertyPage.tabConfigFiles.scan.note.label";
    private PropertiesModel model;
    private PropertiesProject project;
    private Text suffixesText;
    private Table configsTable;
    private TableViewer configsViewer;
    private Label errorLabel;
    private Button addButton;
    private Button addJavaConfigButton;
    private Button removeButton;
    private Button scanButton;
    private Button enableImportText;
    private IModelElement selectedElement;
    private Color grayColor = new Color((Device)Display.getDefault(), 150, 150, 150);
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ConfigFilesTab.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IModelChangeListener modelChangeListener = new IModelChangeListener(){

        public void elementChanged(ModelChangeEvent event) {
            if (ConfigFilesTab.this.configsViewer != null && !ConfigFilesTab.this.configsViewer.getControl().isDisposed()) {
                ConfigFilesTab.this.configsViewer.refresh();
            }
        }
    };
    private boolean hasUserMadeChanges;
    private Button ignoreMissingNamespaceHandlerText;

    public ConfigFilesTab(PropertiesModel model, PropertiesProject project, IModelElement selectedModelElement) {
        this.model = model;
        this.project = project;
        this.calculateSelectedElement(selectedModelElement);
    }

    private void calculateSelectedElement(IModelElement modelElement) {
        if (modelElement != null && this.project != null) {
            this.selectedElement = this.project.getConfig(modelElement.getElementName());
        }
    }

    public boolean hasUserMadeChanges() {
        return this.hasUserMadeChanges;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 64);
        description.setText(BeansUIPlugin.getResourceString(DESCRIPTION));
        description.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.heightHint = 250;
        this.configsTable.setLayoutData((Object)data);
        this.configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFilesTab.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(this.configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new ConfigFilesContentProvider((IBeansProject)this.project));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new PropertiesModelLabelProvider());
        this.configsViewer.setInput((Object)this);
        this.configsViewer.setSorter((ViewerSorter)new ConfigFilesSorter());
        if (this.selectedElement != null) {
            this.configsViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
        }
        if (BeansConfigLocatorFactory.hasEnabledBeansConfigLocatorDefinitions((IProject)this.project.getProject())) {
            Label note = new Label(composite, 64);
            note.setText(BeansUIPlugin.getResourceString(NOTE_LABEL));
            note.setLayoutData((Object)new GridData(768));
        }
        Label options = new Label(composite, 64);
        options.setText("Options:");
        options.setLayoutData((Object)new GridData(768));
        this.enableImportText = SpringUIUtils.createCheckBox((Composite)composite, (String)BeansUIPlugin.getResourceString(ENABLE_IMPORT_LABEL));
        this.enableImportText.setSelection(this.project.isImportsEnabled());
        this.enableImportText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFilesTab.this.handleImportEnabledChanged();
            }
        });
        this.ignoreMissingNamespaceHandlerText = SpringUIUtils.createCheckBox((Composite)composite, (String)BeansUIPlugin.getResourceString(IGNORE_MISSING_NAMESPACEHANDLER_LABEL));
        this.ignoreMissingNamespaceHandlerText.setSelection(SpringCorePreferences.getProjectPreferences((IProject)this.project.getProject(), (String)"org.springframework.ide.eclipse.beans.core").getBoolean("ignoreMissingNamespaceHandler", false));
        this.ignoreMissingNamespaceHandlerText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFilesTab.this.hasUserMadeChanges = true;
            }
        });
        this.suffixesText = SpringUIUtils.createTextField((Composite)composite, (String)BeansUIPlugin.getResourceString(SUFFIXES_LABEL));
        this.suffixesText.setText(StringUtils.collectionToDelimitedString((Collection)this.project.getConfigSuffixes(), (String)","));
        this.suffixesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigFilesTab.this.handleSuffixesTextModified();
            }
        });
        this.errorLabel = new Label(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setForeground(JFaceColors.getErrorText((Display)parent.getDisplay()));
        this.errorLabel.setBackground(JFaceColors.getErrorBackground((Display)parent.getDisplay()));
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(ADD_XML_CONFIG_BUTTON), (SelectionListener)this.buttonListener);
        this.addJavaConfigButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(ADD_JAVA_CONFIG_BUTTON), (SelectionListener)this.buttonListener);
        this.removeButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(REMOVE_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.scanButton = SpringUIUtils.createButton((Composite)buttonArea, (String)"Scan...", (SelectionListener)this.buttonListener);
        this.model.addChangeListener(this.modelChangeListener);
        this.handleSuffixesTextModified();
        this.hasUserMadeChanges = false;
        this.handleTableSelectionChanged();
        return composite;
    }

    public boolean shouldIgnoreMissingNamespaceHandler() {
        return this.ignoreMissingNamespaceHandlerText.getSelection();
    }

    private void handleImportEnabledChanged() {
        if (this.project.isImportsEnabled() && !this.enableImportText.getSelection()) {
            this.hasUserMadeChanges = true;
            this.project.setImportsEnabled(this.enableImportText.getSelection());
        } else if (!this.project.isImportsEnabled() && this.enableImportText.getSelection()) {
            this.hasUserMadeChanges = true;
            this.project.setImportsEnabled(this.enableImportText.getSelection());
        }
    }

    public void dispose() {
        this.model.removeChangeListener(this.modelChangeListener);
    }

    private void handleSuffixesTextModified() {
        String errorMessage = null;
        LinkedHashSet<String> suffixes = new LinkedHashSet<String>();
        String extText = this.suffixesText.getText().trim();
        if (extText.length() == 0) {
            errorMessage = BeansUIPlugin.getResourceString(ERROR_NO_SUFFIXES);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(extText, ",");
            while (tokenizer.hasMoreTokens()) {
                String suffix = tokenizer.nextToken().trim();
                if (this.isValidSuffix(suffix)) {
                    suffixes.add(suffix);
                    continue;
                }
                errorMessage = BeansUIPlugin.getResourceString(ERROR_INVALID_SUFFIXES);
                break;
            }
            if (errorMessage == null) {
                this.project.setConfigSuffixes(suffixes);
                this.hasUserMadeChanges = true;
            }
        }
        if (errorMessage != null) {
            this.errorLabel.setText(errorMessage);
            this.addButton.setEnabled(false);
        } else {
            this.errorLabel.setText("");
            this.addButton.setEnabled(true);
        }
        this.errorLabel.getParent().update();
    }

    private boolean isValidSuffix(String suffix) {
        return suffix.length() != 0;
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
        } else if (selection.getFirstElement() instanceof IBeansConfig && ((IBeansConfig)selection.getFirstElement()).getType() == IBeansConfig.Type.MANUAL) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private void handleButtonPressed(Button button) {
        if (button == this.addButton) {
            this.handleAddButtonPressed();
        } else if (button == this.addJavaConfigButton) {
            this.handleJavaConfigButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.scanButton) {
            this.handleScanButtonPressed();
        }
        this.handleTableSelectionChanged();
        this.configsTable.setFocus();
    }

    protected void handleScanButtonPressed() {
        Object[] selection;
        ScannedFilesContentProvider contentProvider = new ScannedFilesContentProvider(this.suffixesText.getText());
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new ScannedFilesLabelProvider(), contentProvider){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Label note = new Label(composite, 64);
                note.setText(BeansUIPlugin.getResourceString(ConfigFilesTab.SCAN_NOTE_LABEL));
                note.setLayoutData((Object)new GridData(768));
                return composite;
            }
        };
        dialog.setTitle(BeansUIPlugin.getResourceString(DIALOG_TITLE));
        dialog.setMessage(BeansUIPlugin.getResourceString(DIALOG_MESSAGE));
        dialog.addFilter((ViewerFilter)new ScannedFilesFilter(this.project.getConfigSuffixes()));
        dialog.setValidator((ISelectionStatusValidator)new ScannedFilesValidator(true));
        dialog.setInput((Object)this.project.getProject());
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setInitialSelections(contentProvider.getElements(this.project.getProject()));
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                String config;
                Object element = objectArray[n2];
                if (element instanceof IType) {
                    IType type = (IType)element;
                    config = "java:" + type.getFullyQualifiedName();
                } else if (element instanceof ZipEntryStorage) {
                    ZipEntryStorage storage = (ZipEntryStorage)element;
                    config = storage.getFullName();
                } else {
                    IFile file = (IFile)element;
                    config = file.getProjectRelativePath().toString();
                }
                this.project.addConfig(config, IBeansConfig.Type.MANUAL);
                ++n2;
            }
            this.configsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleJavaConfigButtonPressed() {
        SelectionDialog dialog = this.createFilteredTypesDialog();
        if (dialog != null && dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            if (selection != null && selection.length > 0) {
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String config = null;
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        config = "java:" + type.getFullyQualifiedName();
                    }
                    if (config != null) {
                        this.project.addConfig(config, IBeansConfig.Type.MANUAL);
                    }
                    ++n2;
                }
            }
            this.configsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private SelectionDialog createFilteredTypesDialog() {
        SelectionDialog dialog = null;
        IJavaProject javaProj = JdtUtils.getJavaProject((IProject)this.project.getProject());
        if (javaProj != null) {
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProj});
            Set annotatedTypes = org.springframework.ide.eclipse.core.java.JdtUtils.searchForJavaConfigs((IJavaSearchScope)scope);
            final HashSet<String> filteredResults = new HashSet<String>();
            for (IType type : annotatedTypes) {
                filteredResults.add(String.valueOf(type.getPackageFragment().getElementName()) + "/" + type.getTypeQualifiedName('.'));
            }
            try {
                dialog = JavaUI.createTypeDialog((Shell)SpringUIUtils.getStandardDisplay().getActiveShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)256, (boolean)true, (String)"**", (TypeSelectionExtension)new TypeSelectionExtension(){

                    public ITypeInfoFilterExtension getFilterExtension() {
                        return new ITypeInfoFilterExtension(){

                            public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append(typeInfoRequestor.getPackageName()).append('/');
                                String enclosingName = typeInfoRequestor.getEnclosingName();
                                if (enclosingName.length() > 0) {
                                    buffer.append(enclosingName).append('.');
                                }
                                buffer.append(typeInfoRequestor.getTypeName());
                                return filteredResults.contains(buffer.toString());
                            }
                        };
                    }
                });
                dialog.setTitle(BeansUIPlugin.getResourceString(DIALOG_TITLE));
                dialog.setMessage(BeansUIPlugin.getResourceString(DIALOG_MESSAGE));
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui", "An error occurred while opening dialog.", (Throwable)e));
            }
        }
        return dialog;
    }

    private void handleAddButtonPressed() {
        Object[] selection;
        FilteredElementTreeSelectionDialog dialog;
        FilteredElementTreeSelectionDialog selDialog;
        if (SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)2)) {
            selDialog = new FilteredElementTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new NonJavaResourceContentProvider());
            selDialog.addFilter((ViewerFilter)new ConfigFileFilter(this.project.getConfigSuffixes()));
            selDialog.setValidator((ISelectionStatusValidator)new StorageSelectionValidator(true));
            selDialog.setInput((Object)this.project.getProject());
            selDialog.setSorter((ViewerSorter)new JavaElementSorter());
            dialog = selDialog;
        } else {
            selDialog = new ElementTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new NonJavaResourceContentProvider());
            selDialog.addFilter((ViewerFilter)new ConfigFileFilter(this.project.getConfigSuffixes()));
            selDialog.setValidator((ISelectionStatusValidator)new StorageSelectionValidator(true));
            selDialog.setInput((Object)this.project.getProject());
            selDialog.setSorter((ViewerSorter)new JavaElementSorter());
            dialog = selDialog;
        }
        dialog.setTitle(BeansUIPlugin.getResourceString(DIALOG_TITLE));
        dialog.setMessage(BeansUIPlugin.getResourceString(DIALOG_MESSAGE));
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String config = null;
                if (element instanceof ZipEntryStorage) {
                    ZipEntryStorage storage = (ZipEntryStorage)element;
                    config = storage.getFullName();
                } else if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    config = file.getProjectRelativePath().toString();
                } else if (element instanceof JarEntryFile) {
                    IPath fullPath = ((JarPackageFragmentRoot)((JarEntryFile)element).getPackageFragmentRoot()).getPath();
                    String entryName = ((JarEntryFile)element).getFullPath().toString();
                    String[] stringArray = JavaCore.getClasspathVariableNames();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name = stringArray[n4];
                        IPath variablePath = JavaCore.getClasspathVariable((String)name);
                        if (variablePath != null && variablePath.isPrefixOf(fullPath)) {
                            if (!MessageDialog.openQuestion((Shell)SpringUIUtils.getStandardDisplay().getActiveShell(), (String)"Use classpath variable", (String)("Do you want to use the classpath variable '" + name + "' to refer to the config file\n'" + entryName + "'?"))) break;
                            fullPath = new Path(name).append(fullPath.removeFirstSegments(variablePath.segmentCount()));
                            break;
                        }
                        ++n4;
                    }
                    config = "external:/" + fullPath.toString() + "!" + entryName;
                }
                if (config != null) {
                    this.project.addConfig(config, IBeansConfig.Type.MANUAL);
                }
                ++n2;
            }
            this.configsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (!selection.isEmpty()) {
            for (IBeansConfig config : selection) {
                this.project.removeConfig(config.getElementName());
            }
            this.configsViewer.refresh(false);
            this.hasUserMadeChanges = true;
        }
    }

    private class ConfigFileFilter
    extends JavaFileSuffixFilter {
        public ConfigFileFilter(Set<String> allowedFileExtensions) {
            super(allowedFileExtensions);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (super.select(viewer, parent, element)) {
                if (element instanceof JarPackageFragmentRoot) {
                    try {
                        IResource resource = ((JarPackageFragmentRoot)element).getUnderlyingResource();
                        return resource == null || resource.getProject().equals((Object)ConfigFilesTab.this.project.getProject());
                    }
                    catch (JavaModelException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui", "An error occurred while searching for config files.", (Throwable)e));
                    }
                } else if (element instanceof JarEntryFile) {
                    String name = ((JarEntryFile)element).getName();
                    return !"pom.xml".equals(name);
                }
                return true;
            }
            return false;
        }

        protected boolean selectFile(IFile element) {
            if ("pom.xml".equals(element.getName())) {
                return false;
            }
            IBeansProject project = BeansCorePlugin.getModel().getProject(element.getProject());
            if (project != null) {
                IBeansConfig beansConfig = project.getConfig(element);
                return beansConfig == null;
            }
            return false;
        }
    }

    private class ConfigFilesContentProvider
    implements IStructuredContentProvider {
        private IBeansProject project;

        public ConfigFilesContentProvider(IBeansProject project) {
            this.project = project;
        }

        public Object[] getElements(Object obj) {
            return new LinkedHashSet(this.project.getConfigs()).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            ConfigFilesTab.this.grayColor.dispose();
        }
    }

    private static class ConfigFilesSorter
    extends ViewerSorter {
        private ConfigFilesSorter() {
        }

        public int category(Object element) {
            if (element instanceof IBeansConfig) {
                if (((IBeansConfig)element).getElementName().indexOf(47) == -1) {
                    return Category.ROOT_DIR.ordinal();
                }
                return Category.SUB_DIR.ordinal();
            }
            return Category.OTHER.ordinal();
        }

        private static enum Category {
            SUB_DIR,
            ROOT_DIR,
            OTHER;

        }
    }

    private class LabelProvider
    extends JavaElementLabelProvider
    implements IColorProvider {
        public LabelProvider() {
            super(272);
        }

        public String getText(Object element) {
            String label = super.getText(element);
            if (element instanceof IFile) {
                IBeansConfig bc = BeansCorePlugin.getModel().getConfig((IFile)element, true);
                if (bc instanceof IImportedBeansConfig) {
                    label = String.valueOf(label) + " [imported]";
                }
                if (bc != null && bc.getType() == IBeansConfig.Type.AUTO_DETECTED) {
                    label = String.valueOf(label) + " [auto detected]";
                }
            } else if (element instanceof ZipEntryStorage) {
                return ((ZipEntryStorage)element).getEntryName();
            }
            if (label != null && label.startsWith("external:/")) {
                label = label.substring("external:/".length());
            }
            return label;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof IBeansConfig && ((IBeansConfig)element).getType() == IBeansConfig.Type.AUTO_DETECTED) {
                return ConfigFilesTab.this.grayColor;
            }
            return null;
        }
    }

    private final class ScannedFilesContentProvider
    implements ITreeContentProvider {
        private Object[] scannedFiles = null;

        public ScannedFilesContentProvider(final String fileSuffixes) {
            final HashSet files = new HashSet();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProjectScanningBeansConfigLocator locator = new ProjectScanningBeansConfigLocator(fileSuffixes);
                    files.addAll(locator.locateBeansConfigs(ConfigFilesTab.this.project.getProject(), monitor));
                    ProjectScanningJavaConfigLocator javaLocator = new ProjectScanningJavaConfigLocator();
                    files.addAll(javaLocator.locateJavaConfigs(ConfigFilesTab.this.project.getProject(), monitor));
                }
            };
            try {
                ProgressMonitorDialog context = new ProgressMonitorDialog(SpringUIUtils.getStandardDisplay().getActiveShell());
                context.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui", "An error occurred while scanning for config files.", (Throwable)e));
            }
            catch (InterruptedException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui", "An error occurred while scanning for config files.", (Throwable)e));
            }
            this.scannedFiles = files.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return IModelElement.NO_CHILDREN;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.scannedFiles;
        }
    }

    private class ScannedFilesFilter
    extends ConfigFileFilter {
        public ScannedFilesFilter(Set<String> allowedFileExtensions) {
            super(allowedFileExtensions);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IType) {
                IBeansProject beansProj = BeansCorePlugin.getModel().getProject(ConfigFilesTab.this.project.getProject());
                if (beansProj != null) {
                    IType type = (IType)element;
                    IBeansConfig beansConfig = ConfigFilesTab.this.project.getConfig("java:" + type.getFullyQualifiedName());
                    return beansConfig == null;
                }
                return true;
            }
            return super.select(viewer, parent, element);
        }
    }

    private class ScannedFilesLabelProvider
    extends JavaElementLabelProvider {
        private ScannedFilesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IType) {
                return ((IType)element).getFullyQualifiedName();
            }
            if (element instanceof IFile) {
                return ((IFile)element).getProjectRelativePath().toString();
            }
            return super.getText(element);
        }
    }

    private class ScannedFilesValidator
    extends StorageSelectionValidator {
        public ScannedFilesValidator(boolean multiSelect) {
            super(multiSelect);
        }

        public boolean isValid(Object selection) {
            if (selection instanceof IType) {
                return true;
            }
            return super.isValid(selection);
        }
    }
}

