/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.inplace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelContentProvider;
import org.springframework.ide.eclipse.beans.ui.navigator.BeansNavigatorLabelProvider;
import org.springframework.ide.eclipse.beans.ui.navigator.BeansNavigatorSorter;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeansInplaceOutlineDialog {
    public static final String STORE_DISABLE_RESTORE_SIZE = "DISABLE_RESTORE_SIZE";
    public static final String STORE_DISABLE_RESTORE_LOCATION = "DISABLE_RESTORE_LOCATION";
    private static final String STORE_LOCATION_X = "location.x";
    private static final String STORE_LOCATION_Y = "location.y";
    private static final String STORE_SIZE_WIDTH = "size.width";
    private static final String STORE_SIZE_HEIGHT = "size.height";
    private final String sectionName = BeansInplaceOutlineDialog.class.getName();
    private Text filterText;
    private StringMatcher stringMatcher;
    private Font statusTextFont;
    private List<Object> filteredElements = new ArrayList<Object>();
    private Rectangle bounds;
    private Rectangle trim;
    private ToolBar toolBar;
    private MenuManager viewMenuManager;
    private IModelElement lastSelection;
    private IWorkbenchPart workbenchPart;
    private IBeansConfig selectedBeansConfig;
    private final String invokingCommandId = "org.springframework.ide.eclipse.beans.ui.inplace.show";
    private boolean isShowingParent = false;
    private Command invokingCommand;
    private KeyAdapter keyAdapter;
    private TriggerSequence[] invokingCommandTriggerSequences;
    private Label statusField;
    private Action doubleClickAction;
    private boolean isDeactivateListenerActive = false;
    private Composite composite;
    private Composite viewMenuButtonComposite;
    private int shellStyle;
    private Listener deactivateListener;
    private Shell parentShell;
    private Shell dialogShell;
    private TreeViewer viewer;

    public BeansInplaceOutlineDialog(Shell parent) {
        this.parentShell = parent;
        this.shellStyle = 16;
    }

    public void open() {
        if (this.dialogShell != null) {
            this.close();
        }
        if ("org.springframework.ide.eclipse.beans.ui.inplace.show" != null) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            this.invokingCommand = commandService.getCommand("org.springframework.ide.eclipse.beans.ui.inplace.show");
            if (this.invokingCommand != null && !this.invokingCommand.isDefined()) {
                this.invokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.createShell();
        this.createComposites();
        this.filterText = this.createFilterText(this.viewMenuButtonComposite);
        this.createViewMenu(this.viewMenuButtonComposite);
        this.createHorizontalSeparator(this.composite);
        this.viewer = this.createTreeViewer(this.composite, 768);
        this.createStatusField(this.composite);
        this.addListenersToTree(this.viewer);
        this.viewMenuButtonComposite.setTabList(new Control[]{this.filterText});
        this.composite.setTabList(new Control[]{this.viewMenuButtonComposite, this.viewer.getTree()});
        this.setInfoSystemColor();
        this.installFilter();
        this.addListenersToShell();
        this.createContents();
        this.initializeBounds();
        this.dialogShell.open();
    }

    private void createShell() {
        this.dialogShell = new Shell(this.parentShell, this.shellStyle);
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                BeansInplaceOutlineDialog.this.dispose();
            }
        });
        Display display = this.dialogShell.getDisplay();
        this.dialogShell.setBackground(display.getSystemColor(2));
        int border = (this.shellStyle & 8) == 0 ? 0 : 1;
        this.dialogShell.setLayout((Layout)new BorderFillLayout(border));
    }

    private void createComposites() {
        this.composite = new Composite((Composite)this.dialogShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(768));
        this.viewMenuButtonComposite = new Composite(this.composite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewMenuButtonComposite.setLayout((Layout)layout);
        this.viewMenuButtonComposite.setLayoutData((Object)new GridData(768));
    }

    private TreeViewer createTreeViewer(Composite parent, int style) {
        ViewerFilter[] viewFilters;
        this.viewer = new TreeViewer(parent, 4 | style & 0xFFFFFFFD);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new BeansModelContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new BeansNavigatorLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setSorter((ViewerSorter)new BeansNavigatorSorter());
        this.viewer.addFilter((ViewerFilter)new NamePatternFilter());
        INavigatorContentService contentService = NavigatorContentServiceFactory.INSTANCE.createContentService("org.springframework.ide.eclipse.ui.navigator.springExplorer");
        ViewerFilter[] viewerFilterArray = viewFilters = contentService.getFilterService().getVisibleFilters(false);
        int n = viewFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewFilter = viewerFilterArray[n2];
            this.viewer.addFilter(viewFilter);
            ++n2;
        }
        return this.viewer;
    }

    private void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void setInfoSystemColor() {
        Display display = this.dialogShell.getDisplay();
        this.viewer.getTree().setForeground(display.getSystemColor(28));
        this.filterText.setForeground(display.getSystemColor(28));
        this.composite.setForeground(display.getSystemColor(28));
        this.viewMenuButtonComposite.setForeground(display.getSystemColor(28));
        this.toolBar.setForeground(display.getSystemColor(28));
        this.statusField.setForeground(display.getSystemColor(17));
        this.viewer.getTree().setBackground(display.getSystemColor(29));
        this.filterText.setBackground(display.getSystemColor(29));
        this.composite.setBackground(display.getSystemColor(29));
        this.viewMenuButtonComposite.setBackground(display.getSystemColor(29));
        this.toolBar.setBackground(display.getSystemColor(29));
        this.statusField.setBackground(display.getSystemColor(29));
    }

    private void addListenersToTree(TreeViewer treeViewer) {
        final Tree tree = treeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    BeansInplaceOutlineDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BeansInplaceOutlineDialog.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = BeansInplaceOutlineDialog.this.viewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = BeansInplaceOutlineDialog.this.viewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        BeansInplaceOutlineDialog.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.doubleClickAction = new Action(){

            public void run() {
                BeansInplaceOutlineDialog.this.gotoSelectedElement();
            }
        };
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BeansInplaceOutlineDialog.this.doubleClickAction.run();
                if (BeansInplaceOutlineDialog.this.dialogShell != null && BeansInplaceOutlineDialog.this.dialogShell.isDisposed()) {
                    BeansInplaceOutlineDialog.this.dispose();
                }
            }
        });
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
    }

    private void addListenersToShell() {
        this.dialogShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BeansInplaceOutlineDialog.this.close();
                if (BeansInplaceOutlineDialog.this.statusTextFont != null && !BeansInplaceOutlineDialog.this.statusTextFont.isDisposed()) {
                    BeansInplaceOutlineDialog.this.statusTextFont.dispose();
                }
                BeansInplaceOutlineDialog.this.viewer = null;
                BeansInplaceOutlineDialog.this.composite = null;
                BeansInplaceOutlineDialog.this.filterText = null;
                BeansInplaceOutlineDialog.this.statusTextFont = null;
            }
        });
        this.deactivateListener = new Listener(){

            public void handleEvent(Event event) {
                if (BeansInplaceOutlineDialog.this.isDeactivateListenerActive) {
                    BeansInplaceOutlineDialog.this.dispose();
                }
            }
        };
        this.dialogShell.addListener(27, this.deactivateListener);
        this.isDeactivateListenerActive = true;
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (e.widget == BeansInplaceOutlineDialog.this.dialogShell && BeansInplaceOutlineDialog.this.dialogShell.getShells().length == 0) {
                    BeansInplaceOutlineDialog.this.isDeactivateListenerActive = true;
                }
            }
        });
        this.dialogShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                BeansInplaceOutlineDialog.this.bounds = BeansInplaceOutlineDialog.this.dialogShell.getBounds();
                if (BeansInplaceOutlineDialog.this.trim != null) {
                    Point location = BeansInplaceOutlineDialog.this.composite.getLocation();
                    ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.x = ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.x - ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).trim.x + location.x;
                    ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.y = ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.y - ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).trim.y + location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                BeansInplaceOutlineDialog.this.bounds = BeansInplaceOutlineDialog.this.dialogShell.getBounds();
                if (BeansInplaceOutlineDialog.this.trim != null) {
                    Point location = BeansInplaceOutlineDialog.this.composite.getLocation();
                    ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.x = ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.x - ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).trim.x + location.x;
                    ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.y = ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).bounds.y - ((BeansInplaceOutlineDialog)BeansInplaceOutlineDialog.this).trim.y + location.y;
                }
            }
        });
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem viewMenuButton = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        this.toolBar.setLayoutData((Object)data);
        viewMenuButton.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.elcl16view_menu.gif"));
        viewMenuButton.setDisabledImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.dlcl16view_menu.gif"));
        viewMenuButton.setToolTipText("Menu");
        viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeansInplaceOutlineDialog.this.showViewMenu();
            }
        });
    }

    private void showViewMenu() {
        this.isDeactivateListenerActive = false;
        Menu aMenu = this.getViewMenuManager().createContextMenu((Control)this.dialogShell);
        Rectangle bounds = this.toolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.dialogShell.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
                BeansInplaceOutlineDialog.this.isDeactivateListenerActive = true;
            }

            public void menuShown(MenuEvent e) {
            }
        });
        aMenu.setVisible(true);
    }

    private MenuManager getViewMenuManager() {
        if (this.viewMenuManager == null) {
            this.viewMenuManager = new MenuManager();
            this.fillViewMenu((IMenuManager)this.viewMenuManager);
        }
        return this.viewMenuManager;
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new GroupMarker("SystemMenuStart"));
        viewMenu.add((IAction)new MoveAction());
        viewMenu.add((IAction)new ResizeAction());
        viewMenu.add((IAction)new RememberBoundsAction());
        viewMenu.add((IContributionItem)new Separator("SystemMenuEnd"));
    }

    private void createStatusField(Composite parent) {
        FontData[] fontDatas;
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.createHorizontalSeparator(comp);
        this.statusField = new Label(parent, 131072);
        this.statusField.setLayoutData((Object)new GridData(768));
        this.statusField.setText(this.getStatusFieldText());
        Font font = this.statusField.getFont();
        Display display = parent.getDisplay();
        FontData[] fontDataArray = fontDatas = font.getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight(element.getHeight() * 9 / 10);
            ++n2;
        }
        Font statusTextFont = new Font((Device)display, fontDatas);
        this.statusField.setFont(statusTextFont);
    }

    private String getStatusFieldText() {
        TriggerSequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.isShowingParent) {
            return NLS.bind((String)"Press ''{0}'' to hide beans of other files", (Object)keySequence);
        }
        return NLS.bind((String)"Press ''{0}'' to show beans of other files", (Object)keySequence);
    }

    private TriggerSequence[] getInvokingCommandKeySequences() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] bindings = bindingService.getActiveBindingsFor("org.springframework.ide.eclipse.beans.ui.inplace.show");
        if (bindings.length > 0) {
            this.invokingCommandTriggerSequences = bindings;
        }
        return this.invokingCommandTriggerSequences;
    }

    private KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            this.keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    TriggerSequence[] sequences = BeansInplaceOutlineDialog.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    TriggerSequence[] triggerSequenceArray = sequences;
                    int n = sequences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TriggerSequence element = triggerSequenceArray[n2];
                        if (element.equals((Object)keySequence)) {
                            e.doit = false;
                            BeansInplaceOutlineDialog.this.toggleShowParent();
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    public void refresh() {
        if (this.lastSelection != null) {
            Object element = null;
            element = !this.isShowingParent ? this.selectedBeansConfig : this.selectedBeansConfig.getElementParent();
            if (element != null) {
                this.viewer.getControl().setRedraw(false);
                this.viewer.setInput(element);
                this.viewer.expandToLevel(-1);
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.lastSelection), true);
                this.viewer.reveal((Object)this.lastSelection);
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    protected void toggleShowParent() {
        if (this.lastSelection != null && this.workbenchPart != null) {
            Object element = null;
            element = this.isShowingParent ? this.selectedBeansConfig : BeansModelUtils.getParentOfClass((IModelElement)this.selectedBeansConfig, IBeansProject.class);
            if (element != null) {
                this.viewer.getControl().setRedraw(false);
                this.viewer.setInput(element);
                this.viewer.expandToLevel(-1);
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.lastSelection), true);
                this.viewer.reveal((Object)this.lastSelection);
                this.viewer.getControl().setRedraw(true);
            }
        }
        this.isShowingParent = !this.isShowingParent;
        this.updateStatusFieldText();
    }

    protected void updateStatusFieldText() {
        if (this.statusField != null) {
            this.statusField.setText(this.getStatusFieldText());
        }
    }

    private void initializeBounds() {
        Rectangle oldBounds = this.restoreBounds();
        if (oldBounds != null) {
            this.dialogShell.setBounds(oldBounds);
            return;
        }
        this.dialogShell.setBounds(this.getDefaultBounds());
    }

    public Rectangle getDefaultBounds() {
        GC gc = new GC((Drawable)this.composite);
        gc.setFont(this.composite.getFont());
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point size = new Point(60 * width, 10 * height);
        Point location = this.getDefaultLocation(size);
        return new Rectangle(location.x, location.y, size.x, size.y);
    }

    private Point getDefaultLocation(Point initialSize) {
        Monitor monitor = this.dialogShell.getDisplay().getPrimaryMonitor();
        if (this.parentShell != null) {
            monitor = this.parentShell.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = this.parentShell != null ? Geometry.centerPoint((Rectangle)this.parentShell.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = BeansUIPlugin.getDefault().getDialogSettings().getSection(this.sectionName);
        if (settings == null) {
            settings = BeansUIPlugin.getDefault().getDialogSettings().addNewSection(this.sectionName);
        }
        return settings;
    }

    private void storeBounds() {
        boolean controlRestoresLocation;
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean bl = controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        if (this.bounds == null) {
            return;
        }
        if (controlRestoresSize) {
            dialogSettings.put(STORE_SIZE_WIDTH, this.bounds.width);
            dialogSettings.put(STORE_SIZE_HEIGHT, this.bounds.height);
        }
        if (controlRestoresLocation) {
            dialogSettings.put(STORE_LOCATION_X, this.bounds.x);
            dialogSettings.put(STORE_LOCATION_Y, this.bounds.y);
        }
    }

    private Rectangle restoreBounds() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        Rectangle bounds = new Rectangle(-1, -1, -1, -1);
        if (controlRestoresSize) {
            try {
                bounds.width = dialogSettings.getInt(STORE_SIZE_WIDTH);
                bounds.height = dialogSettings.getInt(STORE_SIZE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                bounds.width = -1;
                bounds.height = -1;
            }
        }
        if (controlRestoresLocation) {
            try {
                bounds.x = dialogSettings.getInt(STORE_LOCATION_X);
                bounds.y = dialogSettings.getInt(STORE_LOCATION_Y);
            }
            catch (NumberFormatException numberFormatException) {
                bounds.x = -1;
                bounds.y = -1;
            }
        }
        if (bounds.x == -1 && bounds.y == -1 && bounds.width == -1 && bounds.height == -1) {
            return null;
        }
        Rectangle maxBounds = null;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            maxBounds = this.dialogShell.getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                maxBounds = display.getBounds();
            }
        }
        if (bounds.width > -1 && bounds.height > -1) {
            if (maxBounds != null) {
                bounds.width = Math.min(bounds.width, maxBounds.width);
                bounds.height = Math.min(bounds.height, maxBounds.height);
            }
            bounds.width = Math.max(bounds.width, 30);
            bounds.height = Math.max(bounds.height, 30);
        }
        if (bounds.x > -1 && bounds.y > -1 && maxBounds != null) {
            bounds.x = Math.max(bounds.x, maxBounds.x);
            bounds.y = Math.max(bounds.y, maxBounds.y);
            if (bounds.width > -1 && bounds.height > -1) {
                bounds.x = Math.min(bounds.x, maxBounds.width - bounds.width);
                bounds.y = Math.min(bounds.y, maxBounds.height - bounds.height);
            }
        }
        return bounds;
    }

    private Text createFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    BeansInplaceOutlineDialog.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    BeansInplaceOutlineDialog.this.viewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    BeansInplaceOutlineDialog.this.viewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    BeansInplaceOutlineDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filterText.addKeyListener((KeyListener)this.getKeyAdapter());
        return this.filterText;
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof IResourceModelElement) {
            BeansUIUtils.openInEditor((IResourceModelElement)selectedElement, true);
        } else if (selectedElement instanceof IFile) {
            SpringUIUtils.openInEditor((IFile)((IFile)selectedElement), (int)-1, (boolean)true);
        }
        this.dispose();
    }

    private Object getSelectedElement() {
        if (this.viewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    private void installFilter() {
        this.filterText.setText("");
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                BeansInplaceOutlineDialog.this.setMatcherString(text);
            }
        });
    }

    private void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.stringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.stringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        this.stringMatcherUpdated();
    }

    private void stringMatcherUpdated() {
        this.filteredElements.clear();
        this.viewer.getControl().setRedraw(false);
        this.viewer.refresh();
        this.viewer.expandToLevel(-1);
        this.selectFirstMatch();
        this.viewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        Tree tree = this.viewer.getTree();
        Object element = this.findElement(tree.getItems());
        if (element != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            TreeItem[] items = tree.getItems();
            if (items != null && items.length > 0) {
                Object wr = items[0].getData();
                this.viewer.setSelection((ISelection)new StructuredSelection(wr));
            }
        }
    }

    private Object findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            TreeItem element0 = treeItemArray[n2];
            Object o = element0.getData();
            Object element = null;
            if (o instanceof IBeansModelElement) {
                element = o;
            }
            if (this.stringMatcher == null) {
                return null;
            }
            if (element != null && this.stringMatcher.match(label = labelProvider.getText(element))) {
                return o;
            }
            o = this.findElement(element0.getItems());
            if (o != null) {
                return o;
            }
            ++n2;
        }
        return null;
    }

    private StringMatcher getMatcher() {
        return this.stringMatcher;
    }

    public void close() {
        this.storeBounds();
        this.toolBar = null;
        this.viewMenuManager = null;
    }

    public void dispose() {
        this.filterText = null;
        if (this.dialogShell != null) {
            if (!this.dialogShell.isDisposed()) {
                this.dialogShell.dispose();
            }
            this.dialogShell = null;
            this.parentShell = null;
            this.viewer = null;
            this.composite = null;
        }
    }

    private void performTrackerAction(int style) {
        Tracker tracker = new Tracker(this.dialogShell.getDisplay(), style);
        tracker.setStippled(true);
        Rectangle[] r = new Rectangle[]{this.dialogShell.getBounds()};
        tracker.setRectangles(r);
        this.isDeactivateListenerActive = false;
        if (tracker.open()) {
            this.dialogShell.setBounds(tracker.getRectangles()[0]);
            this.isDeactivateListenerActive = true;
        }
    }

    private void createContents() {
        IFile file;
        IEditorInput input;
        if (this.lastSelection != null && this.workbenchPart != null && (input = SpringUIPlugin.getActiveWorkbenchPage().getActiveEditor().getEditorInput()) instanceof IFileEditorInput && BeansCoreUtils.isBeansConfig((IResource)(file = ((IFileEditorInput)input).getFile()), (boolean)true)) {
            this.selectedBeansConfig = BeansCorePlugin.getModel().getConfig(file, true);
            this.viewer.setInput((Object)this.selectedBeansConfig);
        }
        this.filterText.setText("");
        this.refresh();
    }

    public void setLastSelection(ISelection lastSelection) {
        if (lastSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)lastSelection).getFirstElement();
            IEditorInput input = SpringUIPlugin.getActiveWorkbenchPage().getActiveEditor().getEditorInput();
            IFile file = null;
            if (input instanceof IFileEditorInput) {
                file = ((IFileEditorInput)input).getFile();
            }
            if (obj instanceof IDOMNode && file != null) {
                int endLine;
                IDOMNode node = (IDOMNode)obj;
                int startLine = ((IDOMDocument)node.getOwnerDocument()).getStructuredDocument().getLineOfOffset(node.getStartOffset()) + 1;
                IModelElement mostspecificElement = BeansModelUtils.getMostSpecificModelElement((int)startLine, (int)(endLine = ((IDOMDocument)node.getOwnerDocument()).getStructuredDocument().getLineOfOffset(node.getEndOffset()) + 1), (IFile)file, null);
                this.lastSelection = mostspecificElement != null ? mostspecificElement : BeansCorePlugin.getModel().getConfig(file);
            }
        }
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    public boolean isOpen() {
        return this.dialogShell != null;
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    Point size = element.computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++n2;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++n2;
                }
            }
        }
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super("&Move", 1);
        }

        public void run() {
            BeansInplaceOutlineDialog.this.performTrackerAction(0);
            BeansInplaceOutlineDialog.this.isDeactivateListenerActive = true;
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        protected NamePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = BeansInplaceOutlineDialog.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null && matcher.match(matchName)) {
                if (element instanceof IBeansModelElement || element instanceof IFile) {
                    BeansInplaceOutlineDialog.this.filteredElements.add(element);
                }
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof IBeansModelElement || element instanceof IFile) {
                Object[] children;
                Object[] objectArray = children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element0 = objectArray[n2];
                    if (this.select((Viewer)viewer, element, element0)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                Object element = elements[i];
                if (BeansInplaceOutlineDialog.this.filteredElements.contains(parent)) {
                    if (element instanceof IBeansModelElement) {
                        BeansInplaceOutlineDialog.this.filteredElements.add(element);
                    }
                    out.add(element);
                } else if (BeansInplaceOutlineDialog.this.filteredElements.contains(element)) {
                    out.add(element);
                } else if (this.select(viewer, parent, element)) {
                    out.add(element);
                }
                ++i;
            }
            return out.toArray();
        }
    }

    private class RememberBoundsAction
    extends Action {
        RememberBoundsAction() {
            super("Remember Size and &Location", 2);
            this.setChecked(!BeansInplaceOutlineDialog.this.getDialogSettings().getBoolean(BeansInplaceOutlineDialog.STORE_DISABLE_RESTORE_LOCATION));
        }

        public void run() {
            IDialogSettings settings = BeansInplaceOutlineDialog.this.getDialogSettings();
            boolean newValue = !this.isChecked();
            settings.put(BeansInplaceOutlineDialog.STORE_DISABLE_RESTORE_LOCATION, newValue);
            settings.put(BeansInplaceOutlineDialog.STORE_DISABLE_RESTORE_SIZE, newValue);
            BeansInplaceOutlineDialog.this.isDeactivateListenerActive = true;
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super("&Resize", 1);
        }

        public void run() {
            BeansInplaceOutlineDialog.this.performTrackerAction(16);
            BeansInplaceOutlineDialog.this.isDeactivateListenerActive = true;
        }
    }
}

