/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class RemoveAsBeanConfigAction
extends AbstractHandler {
    private Set<IBeansConfig> selectedItems;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (IBeansConfig config : this.selectedItems) {
            this.removeConfigFromProject(config);
        }
        BeansModelLabelDecorator.update();
        return null;
    }

    private IBeansConfig getConfigFromFile(IFile file) {
        return BeansCorePlugin.getModel().getConfig(file);
    }

    private IBeansConfig getConfigFromType(IType type) {
        IProject project = type.getJavaProject().getProject();
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(project);
        if (beansProject != null) {
            return beansProject.getConfig("java:" + type.getFullyQualifiedName());
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectedItems.size() > 0;
    }

    public void removeConfigFromProject(IBeansConfig config) {
        IBeansProject project;
        if (config != null && (project = BeansModelUtils.getProject((IModelElement)config)) != null) {
            PropertiesProject modelProject = new PropertiesProject(new PropertiesModel(), project);
            modelProject.removeConfig(config.getElementName());
            modelProject.saveDescription();
        }
    }

    public void setEnabled(Object evaluationContext) {
        this.selectedItems = new HashSet<IBeansConfig>();
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBeansConfig config;
                Object element = objectArray[n2];
                if (element instanceof IType) {
                    config = this.getConfigFromType((IType)element);
                    if (config != null) {
                        this.selectedItems.add(config);
                    }
                } else if (element instanceof IFile) {
                    config = this.getConfigFromFile((IFile)element);
                    if (config != null) {
                        this.selectedItems.add(config);
                    }
                } else if (element instanceof IBeansConfig) {
                    this.selectedItems.add((IBeansConfig)element);
                }
                ++n2;
            }
        }
    }
}

