/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.commands.ArquillianAbstractHandler;
import org.jboss.tools.arquillian.ui.internal.dialogs.AddArquillianProfilesDialog;

public class AddArquillianProfilesCommandHandler
extends ArquillianAbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = this.getProject(event);
        this.execute(project);
        return null;
    }

    public void execute(IProject project) {
        try {
            if (project == null || !project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
                Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
                String message = project != null ? "The '" + project.getName() + "' project is not an Arquillian project" : "Invalid project";
                MessageDialog.openInformation((Shell)shell, (String)"Add Arquillian profiles", (String)message);
                return;
            }
            AddArquillianProfilesDialog dialog = new AddArquillianProfilesDialog(this.getShell(), project);
            dialog.open();
        }
        catch (CoreException e) {
            ArquillianUIActivator.log(e);
        }
    }
}

